<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Modules\RolePermission\Entities\Permission;

class AddInstallmentPermissions extends Migration
{
    public function up()
    {
        $routes = [

            ['name' => "Installment", 'route' => 'installment', 'type' => 1, 'parent_route' => null, 'module' => 'Installment',],
            ['name' => 'Plan', 'route' => 'installment.plan.list', 'type' => 2, 'parent_route' => 'installment', 'module' => 'Installment',],
            ['name' => 'Create', 'route' => 'installment.plan.create', 'type' => 3, 'parent_route' => 'installment.plan.list', 'module' => 'Installment',],
            ['name' => 'Edit', 'route' => 'installment.plan.edit', 'type' => 3, 'parent_route' => 'installment.plan.list', 'module' => 'Installment',],
            ['name' => 'Delete', 'route' => 'installment.plan.delete', 'type' => 3, 'parent_route' => 'installment.plan.list', 'module' => 'Installment',],


            ['name' => 'Purchase', 'route' => 'installment.purchase.list', 'type' => 2, 'parent_route' => 'installment', 'module' => 'Installment',],
            ['name' => 'Show Details', 'route' => 'installment.purchase.details', 'type' => 3, 'parent_route' => 'installment.purchase', 'module' => 'Installment',],
            ['name' => 'Cancel', 'route' => 'installment.purchase.change_status', 'type' => 3, 'parent_route' => 'installment.purchase', 'module' => 'Installment',],


            ['name' => 'Overdue History', 'route' => 'installment.overdue_history', 'type' => 2, 'parent_route' => 'installment', 'module' => 'Installment',],
            ['name' => 'Sent Reminder', 'route' => 'installment.sent_reminder', 'type' => 3, 'parent_route' => 'installment.overdue_history', 'module' => 'Installment',],


            ['name' => 'Verified Users', 'route' => 'installment.verified_users', 'type' => 2, 'parent_route' => 'installment', 'module' => 'Installment',],



            ['name' => 'Settings', 'route' => 'installment.settings', 'type' => 2, 'parent_route' => 'installment', 'module' => 'Installment',],
            ['name' => 'Save', 'route' => 'installment.settings.update', 'type' => 3, 'parent_route' => 'installment.settings', 'module' => 'Installment',],


        ];

        if (function_exists('permissionUpdateOrCreate')) {
            permissionUpdateOrCreate($routes);
        }
    }


    public function down()
    {

    }
}
