<?php

use Illuminate\Support\Facades\Route;


Route::prefix('gift')->middleware(['auth'])->group(function () {
    Route::get('course/{id}/{slug}', 'GiftController@giftForm')->name('gift.course');
    Route::post('store', 'GiftController@giftStore')->name('gift.store');
    Route::get('enroll-gift-course/{gift_encrept_id}', 'GiftController@giftEnroll')->name('gift.enroll');

    //Route group
    Route::group(['middleware' => ['auth', 'admin']], function () {
        Route::get('/run-gift-commend', 'AdminGiftController@executeCommand')->name('gift.executeCommand');
        Route::get('/list', 'AdminGiftController@index')->name('gift.list');
        Route::get('/settings', 'AdminGiftController@settings')->name('gift.settings');
        Route::post('/settings', 'AdminGiftController@updateSettings')->name('gift.settings.update');
        Route::get('/send-invitation/{gift_id}', 'AdminGiftController@sendInvitation')->name('gift.send_invitation');
        Route::get('/delete/{gift_id}', 'AdminGiftController@delete')->name('gift.delete');
    });
    Route::group(['middleware' => ['auth']], function () {
        Route::get('/accept-gift/{encrypt_id}', 'AdminGiftController@acceptGift')->name('gift.link');
        Route::get('/my-gifts', 'AdminGiftController@myGifts')->name('gift.myGifts');
    });

});
