<?php

namespace Modules\Cashback\Repositories;

use Carbon\Carbon;
use App\Traits\ImageStore;
use Illuminate\Support\Facades\DB;
use Modules\Cashback\Entities\CashbackRule;
use App\Repositories\Eloquents\BaseRepository;
use Modules\Cashback\Entities\CashbackRuleUser;
use Modules\Cashback\Entities\RuleSpecificItem;
use Modules\Installment\Entities\PlanSpecificItem;
use Modules\Installment\Entities\InstallmentPlanPaymentStep;

class CashbackRuleRepository extends BaseRepository
{
    use ImageStore;

    protected $model;

    public function __construct(CashbackRule $model)
    {
        $this->model = $model;
    }

    function tableColumns()
    {
        return [
            _trans('common.SL'),
            _trans('common.Title'),
            _trans('cashback.Target Type'),
            _trans('cashback.Amount'),
            _trans('cashback.Paid Amount'),
            _trans('cashback.Users'),
            _trans('cashback.Start Date'),
            _trans('cashback.End Date'),
            _trans('common.Status'),
            _trans('common.Action'),
        ];
    }

    function ruleTargetDetails($request, $rule_id, $array_name, $target_type, $rule_specific_item)
    {
        try {
            $delete_previous = $rule_specific_item->rule_specific_item_details_relation()->delete();
            if (!$request->$array_name) return true;
            foreach ($request->$array_name as $target_id) {
                $rule_specific_item->rule_specific_item_details_relation()->create([
                    'item_id' => $target_id,
                    'type' => $target_type,
                ]);
            }
            return true;
        } catch (\Throwable $th) {
            return false;
        }
    }

    function ruleTarget($request, $rule_id)
    {
        try {
            $rule = $this->model->find($rule_id);
            $rule->rule_specific_item()->delete();

            $rule_specific_item = new RuleSpecificItem();
            $rule_specific_item->rule_id = $rule_id;
            $rule_specific_item->target_type = $request->target_type;
            $rule_specific_item->target = $request->target;
            $rule_specific_item->save();
            $this->ruleTargetDetails($request, $rule_id, $rule_specific_item->target, $rule_specific_item->target, $rule_specific_item);

            return true;
        } catch (\Throwable $th) {
            return false;
        }

    }

    function store($request)
    {

        try {
            DB::beginTransaction();

            $rule = new $this->model;
            $rule->title = $request->title;
            $rule->min_purchase_amount = $request->min_purchase_amount;
            $rule->user_type = $request->user_type;
            $rule->amount = $request->amount;
            $rule->amount_type = $request->amount_type;
            $rule->apply_cashback_per_item = $request->apply_cashback_per_item ?? 0;


            $start_time = Carbon::createFromFormat('h:i A', $request->start_time)->format('H:i');
            $rule->start_datetime = Carbon::createFromFormat('d-m-Y H:i', Carbon::parse($request->start_date)->format('d-m-Y') . " " . $start_time);

            if ($request->end_date) {
                $end_time = Carbon::createFromFormat('h:i A', $request->end_time)->format('H:i');
                $rule->end_datetime = Carbon::createFromFormat('d-m-Y H:i', Carbon::parse($request->end_date)->format('d-m-Y') . " " . $end_time);
            } else {
                $rule->end_datetime = null;
            }
            $rule->status = $request->status ?? 0;
            $rule->save();

            $this->ruleTarget($request, $rule->id);

            if ($request->user_type == 'specific_user') {
                $this->rule_users($request);
            }

            DB::commit();
            return $rule;
        } catch (\Throwable $th) {
            DB::rollBack();
        }


    }

    function rule_users($request)
    {
        try {
            $rule = $this->model->find($request->id);
            $rule->users->each->delete();
            foreach ($request->specific_user as $key => $user) {
                $rule_specific_item = new CashbackRuleUser();
                $rule_specific_item->cashback_rule_id = $rule->id;

                $rule_specific_item->user_id = $user;
                $rule_specific_item->save();
            }
            return true;
        } catch (\Throwable $th) {
            return false;
        }
    }

    function updateRule($request)
    {

        try {
            DB::beginTransaction();

            $rule = $this->model->find($request->id);
            $rule->title = $request->title;
            $rule->min_purchase_amount = $request->min_purchase_amount;
            $rule->user_type = $request->user_type;
            $rule->amount = $request->amount;
            $rule->amount_type = $request->amount_type;
            $rule->apply_cashback_per_item = $request->apply_cashback_per_item ?? 0;


            $start_time = Carbon::createFromFormat('h:i A', $request->start_time)->format('H:i');
            $rule->start_datetime = Carbon::createFromFormat('d-m-Y H:i', Carbon::parse($request->start_date)->format('d-m-Y') . " " . $start_time);

            if ($request->end_date) {
                $end_time = Carbon::createFromFormat('h:i A', $request->end_time)->format('H:i');
                $rule->end_datetime = Carbon::createFromFormat('d-m-Y H:i', Carbon::parse($request->end_date)->format('d-m-Y') . " " . $end_time);
            } else {
                $rule->end_datetime = null;
            }
            $rule->status = $request->status == 1 ? 1 : 0;
            $rule->save();

            $this->ruleTarget($request, $rule->id);

            if ($request->user_type == 'specific_user') {
                $this->rule_users($request);
            }

            DB::commit();
            return $rule;
        } catch (\Throwable $th) {
            DB::rollBack();
        }


    }


}
