<?php

namespace Modules\Cashback\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Auth;
use Modules\Cashback\Entities\UserCashback;
use Illuminate\Contracts\Support\Renderable;
use Modules\Cashback\Entities\UserCashbackDetail;

class StudentCashbackController extends Controller
{
    public function studentCashbackList()
    {
        try {
            $data = [];
            $data['title'] = 'Student Cashback List';
            $data['cashback'] = UserCashback::where('user_id', Auth::user()->id)->first();
            if ($data['cashback'] == null) {
                $data['cashbackDetails'] = [];
            } else {
                $data['cashbackDetails'] = UserCashbackDetail::where('user_cashback_id', $data['cashback']->id)->orderBy('id', 'desc')->paginate(10);
            }

            return view(theme('pages.my-cashback'), compact('data'));
        } catch (\Throwable $th) {
            GettingError($th->getMessage(), url()->current(), request()->ip(), request()->userAgent());
        }
    }
}
