<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Modules\RolePermission\Entities\Permission;

class AddCashbackPermission extends Migration
{

    public function up()
    {
        $routes = [
            //Cashback Rule
            ['name' => "Cashback", 'route' => 'cashback', 'type' => 1, 'parent_route' => null, 'module' => 'Cashback',],
            ['name' => 'Rule', 'route' => 'cashback.rules', 'type' => 2, 'parent_route' => 'cashback', 'module' => 'Cashback',],
            ['name' => 'Create', 'route' => 'cashback.rules.create', 'type' => 3, 'parent_route' => 'cashback.rules', 'module' => 'Cashback',],
            ['name' => 'Edit', 'route' => 'cashback.rules.edit', 'type' => 3, 'parent_route' => 'cashback.rules', 'module' => 'Cashback',],
            ['name' => 'Delete', 'route' => 'cashback.rules.delete', 'type' => 3, 'parent_route' => 'cashback.rules', 'module' => 'Cashback',],

            //Cashback transaction
            ['name' => 'Transaction', 'route' => 'cashback.transaction', 'type' => 2, 'parent_route' => 'cashback', 'module' => 'Cashback',],
            ['name' => 'Refund', 'route' => 'cashback.transaction.refund', 'type' => 3, 'parent_route' => 'cashback.transaction', 'module' => 'Cashback',],

            //Cashback History
            ['name' => 'History', 'route' => 'cashback.history', 'type' => 2, 'parent_route' => 'cashback', 'module' => 'Cashback',],
            ['name' => 'Enable or disable', 'route' => 'cashback.history.change_status', 'type' => 3, 'parent_route' => 'cashback.history', 'module' => 'Cashback',],


        ];

        if (function_exists('permissionUpdateOrCreate')) {
            permissionUpdateOrCreate($routes);
        }
    }

    public function down()
    {
        //
    }
}
