<div class="row">
    @if (isset($courses))
        @foreach ($courses as $course)
            <div class="col-lg-6 col-xl-6 mb-4">

                <div class="couse_wizged">
                    <a href="{{ courseDetailsUrl(@$course->id, @$course->type, @$course->slug) }}">
                        <div class="thumb">

                            <div class="thumb_inner lazy" data-src="{{ getCourseImage($course->thumbnail) }}">
                            </div>
                            <x-price-tag :price="$course->price" :discount="$course->discount_price"/>
                        </div>
                    </a>
                    <div class="course_content">
                        <a href="{{ courseDetailsUrl(@$course->id, @$course->type, @$course->slug) }}">

                            <h4 class="noBrake" title=" {{ $course->title }}">
                                {{ $course->title }}
                            </h4>
                        </a>
                        <div class="rating_cart">
                            <div class="rateing">
                                <span>{{ $course->totalReview }}/5</span>

                                <i class="fas fa-star"></i>
                            </div>
                            @auth()
                                @if (!$course->isLoginUserEnrolled && !$course->isLoginUserCart)
                                    <a href="#" class="cart_store" data-id="{{ $course->id }}">
                                        <i class="fas fa-shopping-cart"></i>
                                    </a>
                                @endif
                            @endauth
                            @guest()
                                @if (!$course->isGuestUserCart)
                                    <a href="#" class="cart_store" data-id="{{ $course->id }}">
                                        <i class="fas fa-shopping-cart"></i>
                                    </a>
                                @endif
                            @endguest

                        </div>
                        <div class="course_less_students">
                            <a> <i class="ti-agenda"></i> {{ count($course->lessons) }}
                                {{ __('frontend.Lessons') }}</a>
                            @if(!Settings('hide_total_enrollment_count') == 1)
                                <a>
                                    <i class="ti-user"></i> {{ $course->total_enrolled }}
                                    {{ __('frontend.Students') }}
                                </a>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        @endforeach
    @endif


</div>
