<?php

namespace Modules\Appointment\Repositories\Eloquents;

use App\Repositories\Eloquents\BaseRepository;
use Illuminate\Database\Eloquent\Model;
use Modules\Appointment\Entities\InstructorReview;
use Modules\Appointment\Repositories\Interfaces\ReviewRepositoryInterface;

class ReviewRepository extends BaseRepository implements ReviewRepositoryInterface
{
    public function __construct(
        InstructorReview $model
    ) {
        parent::__construct($model);
    }
    public function index() :array
    {
        $data =[];
        return $data;
    }
    public function create(array $payload): ?Model
    {
        return $this->model->create($this->formatParams($payload));
    }
    private function formatParams($payload, $modelId = null)
    {
        $formatParams = [
            'instructor_id'=>gv($payload, 'instructor_id'),
            'user_id'=> auth()->user()->id,
            'star'=>gv($payload, 'star'),
            'comment'=>gv($payload, 'comment'),
        ];
        return $formatParams;
    }
    public function getEditPreRequisite($modelId):array
    {
        $data =[];
        return $data;
    }
}
