<?php

namespace Modules\Appointment\Http\Requests;

use App\Traits\ValidationMessage;
use Illuminate\Foundation\Http\FormRequest;

class PostRequestForm extends FormRequest
{
    use ValidationMessage;
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'teaching_category'=>['required'],
            'headline'=> ['sometimes', 'nullable'],
            'requirement'=> ['sometimes', 'nullable'],
            'min_price'=> ['sometimes', 'nullable'],
            'max_price'=> ['sometimes', 'nullable'],
            'name'=> ['sometimes', 'nullable'],
            'email'=> ['sometimes', 'nullable'],
        ];
    }

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }
}
