<?php

namespace Modules\Affiliate\Http\Controllers;

use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Affiliate\Entities\AffiliateCommission;
use Modules\Affiliate\Http\Requests\AffiliateBundleCommission;
use Modules\Affiliate\Http\Requests\AffiliateCourseCommission;
use Modules\Affiliate\Http\Requests\AffiliateFlatCommission;
use Modules\Affiliate\Http\Requests\AffiliateSubscriptionCommission;
use Modules\Affiliate\Repositories\AffiliateRepository;
use Modules\BundleSubscription\Entities\BundleCoursePlan;
use Modules\CourseSetting\Entities\Course;
use Modules\Subscription\Entities\CourseSubscription;

class AffiliateCommissionController extends Controller
{
    protected $affiliateRepo;

    public function __construct(AffiliateRepository $affiliateRepo)
    {
        $this->affiliateRepo = $affiliateRepo;
    }
    public function index()
    {
        $data['courses'] = Course::select('id','title')->where('status', 1)->get();

        if (isModuleActive('BundleSubscription')){
            $data['bundles'] = BundleCoursePlan::select('id','title')->where('status', 1)->get();
        }
        if (isModuleActive('Subscription')){
            $data['plans'] = CourseSubscription::select('id','title')->where('status', 1)->get();
        }
        $with=['commable:id,title'];
        $data['commissions'] =AffiliateCommission::with($with)->get();
        return view('affiliate::commissions.index',$data);
    }

    public function flat(AffiliateFlatCommission $request)
    {
        $this->affiliateRepo->configuration($request->validated());

        Toastr::success(trans('common.Operation successful'), trans('common.Success'));
        return redirect()->route('affiliate.commission.settings')->with(['flat' => 1]);
     }

    public function course(AffiliateCourseCommission $request)
    {
        foreach ($request->get('course',[]) as $key => $value) {
            AffiliateCommission::updateOrCreate([
                'commable_type' => Course::class,
                'commable_id' => $value,
                'commission_for' => 'course',

            ],[
                'type' => $request->get('course_commission_type','Percentage')=="Percentage"?1:2,
                'amount' => $request->get('course_commission_amount',0),
            ]);
        }



        Toastr::success(trans('common.Operation successful'), trans('common.Success'));
        return redirect()->route('affiliate.commission.settings')->with(['course' => 1]);
    }

    public function bundle(AffiliateBundleCommission $request)
    {
        foreach ($request->get('bundle',[]) as $value){
            AffiliateCommission::updateOrCreate([
                'commable_type' => BundleCoursePlan::class,
                'commable_id' => $value,
                'commission_for' => 'bundle',

            ], [
                'type' => $request->get('bundle_commission_type', 'Percentage') == "Percentage" ? 1 : 2,
                'amount' => $request->get('bundle_commission_amount', 0),
            ]);
    }
        Toastr::success(trans('common.Operation successful'), trans('common.Success'));
        return redirect()->route('affiliate.commission.settings')->with(['bundle' => 1]);
    }

    public function subscription(AffiliateSubscriptionCommission $request)
    {
        foreach ($request->get('subscription',[]) as $value) {
            AffiliateCommission::updateOrCreate([
                'commable_type' => CourseSubscription::class,
                'commable_id' => $value,
                'commission_for' => 'subscription',

            ],[
                'type' => $request->get('subscription_commission_type','Percentage')=="Percentage"?1:2,
                'amount' => $request->get('subscription_commission_amount',0),
            ]);
        }

        Toastr::success(trans('common.Operation successful'), trans('common.Success'));
        return redirect()->route('affiliate.commission.settings')->with(['subscription' => 1]);
    }

    public function ajaxDeleteForm($id)
    {
        return view('affiliate::commissions.partials.delete',compact('id'));
    }

    public function delete(Request $request)
    {
        $comm =AffiliateCommission::findOrFail($request->id);
        $tab =$comm->commission_for;
        $comm->delete();
        Toastr::success(trans('common.Operation successful'), trans('common.Success'));
        return redirect()->route('affiliate.commission.settings')->with([$tab => 1]);    }
}
