<?php

namespace Modules\Subscription\Http\Controllers;

use Brian2694\Toastr\Facades\Toastr;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Artisan;
use Modules\Subscription\Entities\SubscriptionSetting;

class SettingController extends Controller
{

    public function index()
    {
        $setting = SubscriptionSetting::getData();
        return view('subscription::setting.index', compact('setting'));
    }


    public function store(Request $request)
    {
        if (demoCheck()) {
            return redirect()->back();
        }


        try {
            $setting = SubscriptionSetting::first();

            $setting->commission_rate = (int)$request->commission_rate;
            $setting->type = $request->type;
            $setting->save();

            UpdateGeneralSetting('only_subscription', $request->get('only_subscription'));

            Toastr::success(trans('common.Operation successful'), trans('common.Success'));

            return redirect()->back();

        } catch (Exception $e) {
            Toastr::error(trans('common.Operation failed'), trans('common.Failed'));

            return redirect()->back();
        }
    }

    public function executeCommand()
    {
        Artisan::call('check:subscription',[
            '--no-interaction' => true,
        ]);
        Artisan::call('apply:commission',[
            '--no-interaction' => true,
        ]);
        Toastr::success(trans('common.Operation successful'), trans('common.Success'));
        return redirect()->back();
    }
}
