@extends('backend.master')


@php
    $table_name = 'shipping_methods';
@endphp
@section('table')
    {{ $table_name }}
@endsection

@section('mainContent')

    {!! generateBreadcrumb() !!}

    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">
            <div class="row justify-content-center">
                @if(isset($data['show']))

                    <div class="col-lg-4">
                        <div class="create_div">
                            @include('store::shipping.shipping_methods.components._edit')
                        </div>
                    </div>

                @else

                    <div class="col-lg-4">
                        <div class="create_div">
                            @include('store::shipping.shipping_methods.components._create')
                        </div>
                    </div>

                @endif

                <div class="col-lg-8">
                    <div class="white-box">

                        <div class="box_header common_table_header">
                            <div class="main-title d-md-flex">
                                <h3 class="mb-0 mr-30 mb_xs_15px mb_sm_20px" id="page_title">{{ _trans('store.shipping_method') }}</h3>
                            </div>
                        </div>
                        <div class="QA_section QA_section_heading_custom check_box_table">
                            <div class="QA_table">
                                <div id="method_list">
                                    @include('store::shipping.shipping_methods.components._method_list')
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    @include('store::partials.delete_modal')

@endsection
