@php use Illuminate\Support\Str; @endphp
@extends('backend.master')


@php
    $table_name = 'product_publications';
@endphp
@section('table')
    {{ $table_name }}
@endsection

@section('mainContent')

    @php
        $LanguageList = getLanguageList();
    @endphp

    {!! generateBreadcrumb() !!}

    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">
            <div class="row">
                <div class="col-lg-4">
                    <div class="white-box mb_30  student-details header-menu">
                        <div class="box_header common_table_header mb-10">
                            <div class="main-title d-md-flex mb-0">
                                <h3 class="mb-0">
                                    @if (!isset($edit))
                                        {{ _trans('product.Add New Publication') }}
                                    @else
                                        {{ _trans('product.Update Publication') }}
                                    @endif
                                </h3>
                                @if (isset($edit))
                                    @if (permissionCheck('store.publication.index'))
                                        <a href="{{ route('store.publication.index') }}"
                                           class="primary-btn small fix-gr-bg ms-4"
                                           style="line-height: 25px;" title="{{ __('courses.Add New') }}">+</a>
                                    @endif
                                @endif
                            </div>
                        </div>
                        <div class="row pt-0">
                            @if (isModuleActive('FrontendMultiLang'))
                                <ul class="nav nav-tabs no-bottom-border  mt-sm-md-20 mb-10 ms-3" role="tablist">
                                    @foreach ($LanguageList as $key => $language)
                                        <li class="nav-item">
                                            <a class="nav-link  @if (auth()->user()->language_code == $language->code) active @endif"
                                               href="#element{{ $language->code }}" role="tab"
                                               data-bs-toggle="tab">{{ $language->native }} </a>
                                        </li>
                                    @endforeach
                                </ul>
                            @endif
                        </div>

                        @if (isset($data['edit']))
                            <form action="{{ route('store.publication.update') }}" method="POST" id="category-form"
                                  name="category-form" enctype="multipart/form-data">
                                <input type="hidden" name="id" value="{{ $data['edit']->id }}">
                                @else
                                    @if (permissionCheck('store.publication.store'))
                                        <form action="{{ route('store.publication.store') }}" method="POST"
                                              id="category-form"
                                              name="category-form" enctype="multipart/form-data">
                                            @endif
                                            @endif
                                            @csrf

                                            <div class="tab-content">
                                                @foreach ($LanguageList as $key => $language)
                                                    <div role="tabpanel"
                                                         class="tab-pane fade @if (auth()->user()->language_code == $language->code) show active @endif  "
                                                         id="element{{ $language->code }}">
                                                        <div class="row">
                                                            <div class="col-xl-12">
                                                                <div class="primary_input mb-25">
                                                                    <label class="primary_input_label"
                                                                           for="nameInput">{{ __('common.Name') }}
                                                                        <strong class="text-danger">*</strong></label>
                                                                    <input name="name[{{ $language->code }}]"
                                                                           id="nameInput"
                                                                           class="primary_input_field name {{ @$errors->has('name') ? ' is-invalid' : '' }}"
                                                                           placeholder="{{ __('common.Name') }}"
                                                                           type="text"
                                                                           value="{{ isset($data['edit']) ? $data['edit']->getTranslation('name', $language->code) : old('name.' . $language->code) }}">

                                                                    @if ($errors->has('name'))
                                                                        <span class="invalid-feedback d-block mb-10"
                                                                              role="alert">
                                                        <strong>{{ @$errors->first('name') }}</strong>
                                                    </span>
                                                                    @endif

                                                                </div>
                                                            </div>
                                                            <div class="col-xl-12">
                                                                <div class="primary_input mb-15">
                                                                    <label class="primary_input_label" for="">
                                                                        {{ __('common.Description') }} </label>
                                                                    <textarea class="primary_textarea height_112"
                                                                              name="description[{{ $language->code }}]">{{ isset($data['edit']) ? $data['edit']->getTranslation('description', $language->code) : old('description.' . $language->code) }}</textarea>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                @endforeach

                                            </div>
                                            <div class="row">

                                                <div class="col-xl-12">
                                                    <div class="  mb-25">

                                                        <x-upload-file name="logo" type="image"
                                                                       media_id="{{ isset($data['edit']) ? $data['edit']->logo_media?->media_id : '' }}"
                                                                       label="{{ __('common.Image') }}"
                                                                       note="{{ __('student.Recommended size') }} ({{translatedNumber('150x150')}})"/>

                                                    </div>
                                                </div>


                                                @php
                                                    $tooltip = '';
                                                    if (!permissionCheck('store.category.store')) {
                                                        $tooltip = trans('courses.You have no permission to add');
                                                    }
                                                @endphp
                                                <div class="col-lg-12 text-center">
                                                    <div class="d-flex justify-content-center  ">
                                                        <button type="submit" class="primary-btn semi_large fix-gr-bg"
                                                                data-bs-toggle="tooltip"
                                                                title="{{ @$tooltip }}" id="save_button_parent">
                                                            <i class=" fa fa-check "></i>
                                                            @if (!isset($data['edit']))
                                                                {{ __('common.Save') }}
                                                            @else
                                                                {{ __('common.Update') }}
                                                            @endif
                                                        </button>


                                                    </div>
                                                </div>
                                            </div>

                                        </form>
                    </div>


                </div>
                <div class="col-lg-8">
                    <div class="white-box">
                        <div class="box_header common_table_header mb-10">
                            <div class="main-title d-md-flex mb-0">
                                <h3 class="mb-0" id="page_title">{{ _trans('store.Publication List') }}</h3>
                            </div>
                        </div>
                        <div class="  QA_section QA_section_heading_custom check_box_table">
                            <div class="QA_table ">
                                <div class="">
                                    <table id="lms_table" class="table table-data">
                                        <thead>
                                        <tr>
                                            <th scope="col">{{ __('common.SL') }}</th>
                                            <th scope="col">{{ __('common.Name') }}</th>
                                            <th scope="col">{{ __('common.Logo') }}</th>
                                            <th scope="col">{{ __('common.Description') }}</th>
                                            <th scope="col">{{ __('common.Status') }}</th>
                                            <th scope="col">{{ __('common.Action') }}</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        @foreach ($data['publications'] as $key => $publication)
                                            <tr>
                                                <td>{{ ++$key }}</td>
                                                <td>{{ @$publication->name }}</td>
                                                <td>
                                                    <img src="{{ showImage(@$publication->logo) }}" alt="image"
                                                         width="50px" height="50px">
                                                </td>
                                                <td>{{ Str::limit($publication->description, 50, $end = '...') }}
                                                </td>


                                                <td class="nowrap">
                                                    <x-backend.status :id="$publication->id"
                                                                      :status="$publication->status"
                                                                      :route="'store.category.status'">
                                                    </x-backend.status>

                                                </td>

                                                <td>
                                                    <div class="dropdown CRM_dropdown">
                                                        <button class="btn btn-secondary dropdown-toggle" type="button"
                                                                id="dropdownMenu1{{ @$publication->id }}"
                                                                data-bs-toggle="dropdown" aria-haspopup="true"
                                                                aria-expanded="false">
                                                            {{ __('common.Select') }}
                                                        </button>
                                                        <div class="dropdown-menu dropdown-menu-right"
                                                             aria-labelledby="dropdownMenu1{{ @$publication->id }}">
                                                            @if (permissionCheck('store.publication.edit'))
                                                                <a class="dropdown-item edit_brand"
                                                                   href="{{ route('store.publication.edit', $publication->id) }}">{{ __('common.Edit') }}</a>
                                                            @endif
                                                            @if (permissionCheck('store.publication.destroy'))
                                                                <a onclick="confirm_modal('{{ route('store.publication.destroy', $publication->id) }}');"
                                                                   class="dropdown-item edit_brand">{{ __('common.Delete') }}</a>
                                                            @endif
                                                        </div>
                                                    </div>
                                                </td>
                                            </tr>
                                        @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>


    @include('store::partials.delete_modal')

@endsection

@push('scripts')
    <script type="application/javascript">
        (function ($) {
            "use strict";
            dataTableOptions = updateColumnExportOption(dataTableOptions, [0, 1, 3]);

            $('#lms_table').DataTable(dataTableOptions);

        })(jQuery);

    </script>
@endpush
