<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateProductsTable extends Migration
{
    public function up()
    {
        Schema::create('products', function (Blueprint $table) {
            $table->increments('id');
            $table->unsignedInteger('user_id');
            $table->text('title');
            $table->longText('description')->nullable();
            $table->integer('status')->default(1);
            $table->unsignedBigInteger('category_id');
            $table->unsignedBigInteger('sub_category_id')->nullable();
            $table->unsignedBigInteger('author_id')->nullable();
            $table->unsignedBigInteger('brand_id')->nullable();
            $table->unsignedBigInteger('unit_id')->nullable();
            $table->float('price')->default(0);
            $table->string("discount_type", 50)->nullable();
            $table->double("discount", 16, 2)->default(0);
            $table->string('image')->nullable();
            $table->string('thumbnail')->nullable();
            $table->integer('is_readable')->default(0);
            $table->string("link", 255)->nullable();
            $table->integer('inventory')->nullable();
            $table->integer('inventory_warning')->nullable();
            $table->double('delivery_fee')->nullable();
            $table->integer('delivery_estimated_time')->nullable();
            $table->integer('type')->default(1)->comment('1 => virtual product 2 => physical product');
            $table->integer('commission')->nullable();
            $table->string("pdf", 255)->nullable();
            $table->string("soft_file", 255)->nullable();
            $table->longText('specification')->nullable();
            $table->longText('faq')->nullable();
            $table->integer('lms_id')->default(1);
            $table->boolean('has_variant')->default(0);
            $table->boolean('is_free')->default(0);
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('products');
    }
}
