<?php

namespace Modules\Noticeboard\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Request;

class NoticeboardRequest extends FormRequest
{
    public function rules()
    {
        $route = Request::route()->getName();
        $rules = [];
        if ($route == 'noticeboard.store' || $route == 'noticeboard.update' || $route == 'noticeboard.course.store' || $route == 'noticeboard.course.update') {
            $rules['title'] = 'required';
            $rules['message'] = 'required';
            $rules['type'] = 'required';
            $rules['group'] = 'required';
        }

        if ($route == 'noticeboard.course.show' || $route == 'noticeboard.update' || $route == 'noticeboard.delete' || $route == 'noticeboard.course.update' || $route == 'noticeboard.course.delete') {
            $rules['id'] = 'required';
        }

        if ($route == 'noticeboard.store' || $route == 'noticeboard.update') {
            $rules['role_id'] = 'required';
        }
        if ($route == 'noticeboard.course.store' || $route == 'noticeboard.course.update') {
            $rules['course_id'] = 'required';
        }
        return $rules;
    }

    public function authorize()
    {
        return true;
    }

    public function messages(): array
    {
        return validationMessage($this->rules());
    }
}
