<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateGiftCartsTable extends Migration
{

    public function up()
    {
        Schema::create('gift_carts', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('course_id');
            $table->integer('user_id');
            $table->integer('instructor_id');
            $table->string('tracking');
            $table->float('price');
            $table->integer('gift_id');
            $table->integer('is_gift')->default(1);
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('gift_carts');
    }
}
