<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateGiftRecordsTable extends Migration
{
    public function up()
    {
        Schema::create('gift_records', function (Blueprint $table) {
            $table->id();
            $table->integer('user_id');
            $table->integer('course_id');
            $table->string('gift_user_email')->nullable();
            $table->string('gift_send_time')->nullable();
            $table->string('gift_receiver_name')->nullable();
            $table->integer('gift_receiver_id')->nullable();
            $table->longText('gift_message')->nullable();
            $table->string('gift_status')->nullable()->comment('1 = Add to cart, 2 = Purchased, 3 = Gifted, 4 = Enrolled');
            $table->bigInteger('cart_id')->nullable();
            $table->double('price')->nullable();
            $table->longText('checkout_data')->nullable();
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('gift_records');
    }
}
