<?php

namespace Modules\Assignment\Http\Controllers;

use App\Traits\UploadMedia;
use App\User;
use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Auth;
use Modules\Assignment\Entities\InfixAssignment;
use Modules\CourseSetting\Entities\Course;

class AssignmentController extends Controller
{
    use UploadMedia;

    public function index()
    {
        try {
            $query = InfixAssignment::where('assignment_from', 1);
            if (isModuleActive('Organization') && Auth::user()->isOrganization()) {
                $query->whereHas('creator_info', function ($q) {
                    $q->where('organization_id', Auth::id());
                    $q->orWhere('id', Auth::id());
                });
            }

            $assignments = $query->get();
            $query2 = User::where('role_id', 3);
            if (isModuleActive('Organization') && Auth::user()->isOrganization()) {
                $query2->where('organization_id', Auth::id());
                $query2->orWhere('id', Auth::id());
            }
            $students = $query2->where('status', 1)->get();
            return view('assignment::index', compact('assignments', 'students'));
        } catch (\Exception $e) {
            Toastr::error(trans('common.Operation failed'), trans('common.Failed'));
            return redirect()->back();
        }

    }

    public function courseAssignmentList()
    {
        try {
            $query = InfixAssignment::where('assignment_from', 2);
            if (isModuleActive('Organization') && Auth::user()->isOrganization()) {
                $query->whereHas('creator_info', function ($q) {
                    $q->where('organization_id', Auth::id());
                    $q->orWhere('id', Auth::id());
                });
            }
            $assignments = $query->get();
            $query2 = User::where('role_id', 3);
            if (isModuleActive('Organization') && Auth::user()->isOrganization()) {
                $query2->where('organization_id', Auth::id());
                $query2->orWhere('id', Auth::id());
            }
            $students = $query2->where('status', 1)->get();
            return view('assignment::course_assignment', compact('assignments', 'students'));
        } catch (\Exception $e) {
            Toastr::error(trans('common.Operation failed'), trans('common.Failed'));
            return redirect()->back();
        }

    }


    public function create()
    {
        try {
            $query = Course::where('type', 1);

            if (isModuleActive('Organization') && Auth::user()->isOrganization()) {
                $query->whereHas('creator_info', function ($q) {
                    $q->where('organization_id', Auth::id());
                    $q->orWhere('user_id', Auth::id());
                });
            }
            $courses = $query->get();
            return view('assignment::assignment_add', compact('courses'));
        } catch (\Exception $e) {
            Toastr::error(trans('common.Operation failed'), trans('common.Failed'));
            return redirect()->back();
        }

    }


    public function store(Request $request)
    {
        if (demoCheck()) {
            return redirect()->back();
        }
        $validate_rules = [
            'title' => 'required|max:255',
            'marks' => 'required|min:0',
            'min_parcentage' => 'required|min:0',
            'description' => 'required',
        ];
        $request->validate($validate_rules, validationMessage($validate_rules));

        try {
            $assignment = new InfixAssignment();
            $assignment->title = $request->title;
            $assignment->course_id = $request->course;
            $assignment->marks = (int)$request->marks;
            $assignment->min_parcentage = (int)$request->min_parcentage;
            $assignment->description = $request->description;
            $assignment->assignment_from = 1;
            $assignment->created_by = Auth::user()->id;
            $assignment->last_date_submission = date('Y-m-d', strtotime($request->last_date_submission));
            $assignment->save();

            if ($request->attachment) {
                $assignment->attachment = $this->generateLink($request->attachment, $assignment->id, get_class($assignment), 'attachment');
            }
            $assignment->save();
            Toastr::success(trans('common.Operation successful'), trans('common.Success'));
            return redirect()->route('assignment_list');
        } catch (\Exception $e) {
            Toastr::error(trans('common.Operation failed'), trans('common.Failed'));
            return redirect()->back();
        }
    }


    public function show($id)
    {
        try {
            $query = Course::where('type', 1);

            if (isModuleActive('Organization') && Auth::user()->isOrganization()) {
                $query->whereHas('creator_info', function ($q) {
                    $q->where('organization_id', Auth::id());
                    $q->orWhere('user_id', Auth::id());
                });
            }
            $courses = $query->get();
            $edit = InfixAssignment::find($id);
            return view('assignment::assignment_add', compact('courses', 'edit'));
        } catch (\Exception $e) {
            Toastr::error(trans('common.Operation failed'), trans('common.Failed'));
            return redirect()->back();
        }
    }

    public function edit($id)
    {
        return view('assignment::edit');
    }


    public function update(Request $request)
    {
        $validate_rules = [
            'title' => 'required|max:255',
            'marks' => 'required|min:0',
            'min_parcentage' => 'required|min:0',
            'description' => 'required',
            'id' => 'required',
        ];
        $request->validate($validate_rules, validationMessage($validate_rules));

        try {
            $assignment = InfixAssignment::find($request->id);
            $assignment->title = $request->title;
            $assignment->course_id = $request->course;
            $assignment->marks = (int)$request->marks;
            $assignment->min_parcentage = (int)$request->min_parcentage;
            $assignment->description = $request->description;
            $assignment->last_date_submission = date('Y-m-d', strtotime($request->last_date_submission));
            $assignment->attachment = null;
            $assignment->save();

            $this->removeLink($assignment->id, get_class($assignment));
            if ($request->attachment) {
                $assignment->attachment = $this->generateLink($request->attachment, $assignment->id, get_class($assignment), 'attachment');
            }
            $assignment->save();
            Toastr::success(trans('common.Operation successful'), trans('common.Success'));
            return redirect()->route('assignment_list');
        } catch (\Exception $e) {
            Toastr::error(trans('common.Operation failed'), trans('common.Failed'));
            return redirect()->back();
        }
    }


    public function destroy($id)
    {
        try {
            $edit = InfixAssignment::find($id);
            $edit->delete();

            Toastr::success(trans('common.Operation successful'), trans('common.Success'));
            return redirect()->route('assignment_list');
        } catch (\Exception $e) {
            Toastr::error(trans('common.Operation failed'), trans('common.Failed'));
            return redirect()->back();
        }
    }

}
