@extends('appointment::layouts.master')
@push('styles')
    <style>
        .d-flex.radio-btn-flex > div {
            min-height: 25px;
        }

        .relation-button {
            align-items: center;
        }

        .common-radio2:empty, .common-radio:empty {
            margin-top: 0;
        }
    </style>
@endpush
@section('mainContent')
    <input type="hidden" name="id" value="{{ $setting->id }}">
    {!! generateBreadcrumb() !!}

    <section class="admin-visitor-area up_st_admin_visitor" id="admin-visitor-area">
        <div class="container-fluid p-0">
            <div class="row justify-content-center">
                <div class="col-12">
                    <div class="">
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="white-box">
                                    <div class="main-title mb-25">
                                        <h3 class="mb-0">@lang('appointment.Appointment Setting')
                                        </h3>
                                    </div>

                                    <form action="{{ route('appointment.settings.update', $setting->id) }}"
                                          method="POST" enctype="multipart/form-data">
                                        @csrf
                                        <input type="hidden" name="type" id="profileType" value="profile">

                                        <div class="row">
                                            <div
                                                class="col-lg-6 d-flex relation-button justify-content-between mb-3 justify-content-between">
                                                <p class="text-uppercase mb-0">@lang('appointment.lessons Booked')</p>
                                                <div class="d-flex radio-btn-flex ml-30">
                                                    <div class="me-3">
                                                        <input type="radio" name="lesson_booked" id="lesson_booked_on"
                                                               value="1"
                                                               class="common-radio relationButton" {{ $setting->lesson_booked == 1 ? 'checked':'' }}>
                                                        <label for="lesson_booked_on">@lang('common.Yes')</label>
                                                    </div>
                                                    <div class="me-3">
                                                        <input type="radio" name="lesson_booked" id="lesson_booked"
                                                               value="0"
                                                               class="common-radio relationButton" {{ $setting->lesson_booked == 0 ? 'checked':'' }}>
                                                        <label for="lesson_booked">@lang('common.No')</label>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="col-lg-6 d-flex relation-button justify-content-between mb-3">
                                                <p class="text-uppercase mb-0"> @lang('appointment.Contacted Tutor')
                                                </p>
                                                <div class="d-flex radio-btn-flex ml-30">
                                                    <div class="me-3">
                                                        <input type="radio" name="popular" id="popular_on" value="1"
                                                               class="common-radio relationButton" {{$setting->popular == 1 ? 'checked':'' }}>
                                                        <label for="popular_on">@lang('common.Yes')</label>
                                                    </div>
                                                    <div class="me-3">
                                                        <input type="radio" name="popular" id="popular" value="0"
                                                               class="common-radio relationButton" {{$setting->popular == 0 ? 'checked':'' }}>
                                                        <label for="popular">@lang('common.No')</label>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="col-lg-6 d-flex relation-button justify-content-between mb-3">
                                                <p class="text-uppercase mb-0"> @lang('appointment.Book Trail Lesson')</p>
                                                <div class="d-flex radio-btn-flex ml-30">
                                                    <div class="me-3">
                                                        <input type="radio" name="trail_lesson" id="trail_lesson_on"
                                                               value="1" class="common-radio relationButton"
                                                            {{$setting->trail_lesson == 1 ? 'checked':'' }}>
                                                        <label for="trail_lesson_on">@lang('common.Yes')</label>
                                                    </div>
                                                    <div class="me-3">
                                                        <input type="radio" name="trail_lesson" id="trail_lesson"
                                                               value="0"
                                                               class="common-radio relationButton"
                                                            {{$setting->trail_lesson == 0 ? 'checked':'' }}
                                                        >
                                                        <label for="trail_lesson">@lang('common.No')</label>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-lg-6 d-flex relation-button justify-content-between mb-3">
                                                <p class="text-uppercase mb-0"> @lang('appointment.Review Section')</p>
                                                <div class="d-flex radio-btn-flex ml-30">
                                                    <div class="me-3">
                                                        <input type="radio" name="review_option" id="review_option_on"
                                                               value="1" class="common-radio relationButton"
                                                            {{$setting->review_option == 1 ? 'checked':'' }}>
                                                        <label for="review_option_on">@lang('common.Yes')</label>
                                                    </div>
                                                    <div class="me-3">
                                                        <input type="radio" name="review_option" id="review_option"
                                                               value="0"
                                                               class="common-radio relationButton"
                                                            {{$setting->review_option == 0 ? 'checked':'' }}
                                                        >
                                                        <label for="review_option">@lang('common.No')</label>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-lg-6 d-flex relation-button justify-content-between mb-3">
                                                <p class="text-uppercase mb-0"> @lang('appointment.Review Submit')</p>
                                                <div class="d-flex radio-btn-flex ml-30">
                                                    <div class="me-3">
                                                        <input type="radio" name="submit_review" id="review_submit_on"
                                                               value="1" class="common-radio relationButton"
                                                            {{$setting->submit_review == 1 ? 'checked':'' }}>
                                                        <label for="review_submit_on">@lang('common.Yes')</label>
                                                    </div>
                                                    <div class="me-3">
                                                        <input type="radio" name="submit_review" id="review_submit"
                                                               value="0"
                                                               class="common-radio relationButton"
                                                            {{$setting->submit_review == 0 ? 'checked':'' }}
                                                        >
                                                        <label for="review_submit">@lang('common.No')</label>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="col-lg-6 d-flex relation-button justify-content-between mb-3">
                                                <p class="text-uppercase mb-0"> @lang('appointment.Showing Number Of Student')</p>
                                                <div class="d-flex radio-btn-flex ml-30">
                                                    <div class="me-3">
                                                        <input type="radio" name="number_of_student"
                                                               id="number_of_student_on"
                                                               value="1" class="common-radio relationButton"
                                                            {{$setting->number_of_student == 1 ? 'checked':'' }}>
                                                        <label for="number_of_student_on">@lang('common.Yes')</label>
                                                    </div>
                                                    <div class="me-3">
                                                        <input type="radio" name="number_of_student"
                                                               id="number_of_student"
                                                               value="0"
                                                               class="common-radio relationButton"
                                                            {{$setting->number_of_student == 0 ? 'checked':'' }}
                                                        >
                                                        <label for="number_of_student">@lang('common.No')</label>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row  ">
                                            <div class="col-lg-12 d-flex align-items-center justify-content-center">
                                                <button class="primary-btn small fix-gr-bg profileSettingBtn"><i
                                                        class="ti-check"></i>@lang('common.Update')</button>
                                            </div>
                                        </div>
                                    </form>
                                </div>


                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
@push('scripts')
    <script>
        (function ($) {
            "use strict";
            $(document).ready(function () {
                $(document).on('click', '.accessBtn', function (e) {
                    e.preventDefault();
                    let url = $('#url').val();
                    let accessType = $("#accessType").val();
                    updateSetting(accessType)
                });
                $(document).on('click', '.profileSettingBtn', function (e) {
                    e.preventDefault();
                    let accessType = $("#profileType").val();
                    updateSetting(accessType)
                });

                function updateSetting(accessType) {
                    let url = $('#url').val();
                    let access = $("input[name='access']:checked").val();
                    let id = $("input[name='id']").val();

                    let lesson_booked = $("input[name='lesson_booked']:checked").val();
                    let popular = $("input[name='popular']:checked").val();
                    let trail_lesson = $("input[name='trail_lesson']:checked").val();
                    let review_option = $("input[name='review_option']:checked").val();
                    let submit_review = $("input[name='submit_review']:checked").val();
                    let number_of_student = $("input[name='number_of_student']:checked").val();


                    formData = {
                        id: id,
                        access: access,
                        type: accessType,
                        popular: popular,
                        trail_lesson: trail_lesson,
                        lesson_booked: lesson_booked,
                        number_of_student: number_of_student,
                        review_option: review_option,
                        submit_review: submit_review,

                    }
                    $.ajax({
                        type: 'post',
                        datatype: 'json',
                        data: formData,
                        url: url + "/appointment/settings/update/" + id,
                        success: function (data) {
                            setTimeout(function () {
                                toastr.success("Operation successful", 'Success', {
                                    timeOut: 5000,
                                });
                            }, 500);
                        },
                        error: function (data) {

                        }
                    });
                }
            });
        })(jQuery);

    </script>
@endpush
