<!DOCTYPE html>
<html dir="{{isRtl()?'rtl':''}}" class="{{isRtl()?'rtl':''}}" lang="en" itemscope
      itemtype="{{url('/')}}">
<head>
    @laravelPWA
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}"/>

    <meta property="og:url" content="{{url()->current()}}"/>
    <meta property="og:type" content="website"/>
    <meta property="og:title" content="{{Settings('site_title')}}"/>
    <meta property="og:description" content="{{Settings('footer_about_description')}}"/>
    <meta property="og:image" content="@yield('og_image')"/>

    <title>{{Settings('site_title')}}</title>

    <link rel="stylesheet" href="{{asset('Modules/AoraPageBuilder/Resources/assets/css/bootstrap.min.css')}}"
          data-type="aoraeditor-style"/>

    <link rel="stylesheet"
          href="{{ asset('public/frontend/infixlmstheme') }}/css/fontawesome.css{{assetVersion()}} "
          data-type="aoraeditor-style">

    <link rel="stylesheet" href="{{asset('Modules/AoraPageBuilder/Resources/assets/css/aoraeditor.css')}}"
          data-type="aoraeditor-style"/>
    <link rel="stylesheet"
          href="{{asset('Modules/AoraPageBuilder/Resources/assets/css/aoraeditor-components.css')}}"
          data-type="aoraeditor-style"/>


    <link rel="stylesheet" type="text/css" data-type="aoraeditor-style"
          href="{{asset('Modules/AoraPageBuilder/Resources/assets/css/style.css')}}">

    <x-frontend-dynamic-style-color></x-frontend-dynamic-style-color>

    <style>

    </style>
    <script type="text/javascript" data-type="aoraeditor-script"
            src="{{asset('Modules/AoraPageBuilder/Resources/assets/js/jquery-1.11.3.min.js')}}"></script>
</head>
<body>

<input type="hidden" id="url" value="{{url('/')}}">
<input type="hidden" name="lat" class="lat" value="{{Settings('lat') }}">
<input type="hidden" name="lng" class="lng" value="{{Settings('lng') }}">
<input type="hidden" name="zoom" class="zoom" value="{{Settings('zoom_level')}}">
<div data-aoraeditor="html">

    <div id="content-area">
        @if ($design)
            {!! $design->description !!}
        @endif
    </div>


</div>


<script type="text/javascript"
        src="{{asset('Modules/AoraPageBuilder/Resources/assets/js/bootstrap.min.js')}}"></script>
<script type="text/javascript"
        src="{{asset('Modules/AoraPageBuilder/Resources/assets/js/jquery-ui.min.js')}}"></script>
<script type="text/javascript"
        src="{{asset('Modules/AoraPageBuilder/Resources/assets/js/ckeditor.js')}}"></script>
<script type="text/javascript"
        src="{{asset('Modules/AoraPageBuilder/Resources/assets/js/form-builder.min.js')}}"></script>
<script type="text/javascript"
        src="{{asset('Modules/AoraPageBuilder/Resources/assets/js/form-render.min.js')}}"></script>
<script type="text/javascript"
        src="{{asset('Modules/AoraPageBuilder/Resources/assets/js/aoraeditor.js')}}"></script>

<script type="text/javascript"
        src="{{asset('Modules/AoraPageBuilder/Resources/assets/js/aoraeditor-components.js')}}"></script>


<script data-aoraeditor="script">
    (function ($) {
        "use strict";

        $('#content-area').aoraeditor({
            snippetsUrl: '{{ route('appointment.page.snippet', ['name' => $design->name]) }}',
            title: 'Design {{ $design ? $design->title : '' }} Page',

            extraTopbarItems: {
                pageSetting: {
                    html: '<a href="{{ route('appointment.page.index') }}" title="Back" class="btn-page-setting" data-extra-setting="pageSetting"><i class="fa fa-fw fa-arrow-left"></i></a>'
                }
            },
            onSave: function (content) {
                var url = '{{ route('appointment.page.design.update', ':id') }}';
                url = url.replace(':id', {{ $row->id }});
                $.ajax({
                    url: url,
                    type: "PUT",
                    data: {
                        'body': content,
                        _token: "{{ csrf_token() }}"
                    },
                    success: function (data) {
                        location.reload();
                    }
                });
            },
        });

    })(jQuery);

</script>


<script type="text/javascript" data-aoraeditor="script">
    (function ($) {
        "use strict";

        $('.dynamicData').each(function (i, obj) {
            aoraEditor.loadDynamicContent($(this));
        });


    })(jQuery);

</script>
</body>
</html>
