@extends('backend.master')
@section('table')
    {{ __('appointment_frontend_pages') }}
@endsection
@section('mainContent')
    @include('backend.partials.alertMessage')
    <section class="sms-breadcrumb mb-20 white-box">
        <div class="container-fluid">
            <div class="row justify-content-between">
                <h1>{{ __('frontendmanage.Become Instructor') }}</h1>
                <div class="bc-pages">
                    <a href="{{ route('dashboard') }}">{{ __('common.Dashboard') }}</a>
                    <a href="#">{{ __('frontendmanage.Frontend CMS') }}</a>
                    <a class="active"
                       href="{{ url('frontend/becomeInstructor') }}">{{ __('frontendmanage.Become Instructor') }}</a>
                </div>
            </div>
        </div>
    </section>

    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">
            <div class="row justify-content-center">
                <div class="offset-lg-10 col-lg-2 text-end col-md-12 mb-20">
                    <a target="_blank" href="{{ route('appointment.become-tutor.index') }}"
                       class="primary-btn small fix-gr-bg"> <span
                            class="ti-eye pe-2"></span> {{ __('student.Preview') }} </a>
                </div>
                <div class="col-lg-12">
                    <div class="box_header common_table_header">
                        <div class="main-title d-flex flex-wrap mb-0">
                            <h3 class="mb-0">{{ __('frontendmanage.Become Instructor') }} </h3>
                        </div>
                    </div>
                    <div class="QA_section QA_section_heading_custom check_box_table">
                        <div class="QA_table">
                            <!-- table-responsive -->
                            <div class="">
                                <table id="lms_table" class="table Crm_table_active3">
                                    <thead>
                                    <tr>
                                        <th scope="col">{{ __('common.SL') }}</th>
                                        <th scope="col">{{ __('common.Section') }} </th>
                                        <th scope="col">{{ __('common.Status') }} </th>
                                        <th scope="col">{{ __('common.Action') }}</th>
                                    </tr>
                                    </thead>
                                    <tbody>


                                    @foreach ($settings as $key => $row)
                                        <tr>
                                            <td>{{ $key + 1 }}</td>
                                            <td>{{ $row->title }}</td>
                                            <td>
                                                <label class="switch_toggle">
                                                    <input type="checkbox"
                                                           class="status_enable_disable"
                                                           {{ $row->status ? 'checked' : '' }}
                                                           value="{{ $row->id }}">
                                                    <i class="slider round"></i>
                                                </label>
                                            </td>
                                            <td>
                                                <div class="dropdown CRM_dropdown">
                                                    <button class="btn btn-secondary dropdown-toggle" type="button"
                                                            id="dropdownMenu2" data-bs-toggle="dropdown"
                                                            aria-haspopup="true"
                                                            aria-expanded="false">
                                                        {{ __('common.Action') }}
                                                    </button>
                                                    <div class="dropdown-menu dropdown-menu-right"
                                                         aria-labelledby="dropdownMenu2">
                                                        @if (permissionCheck('appointment.page.design.update'))
                                                            <a href="{{ route('appointment.page.design', $row->id) }}"
                                                               class="dropdown-item">{{ __('appointment.Design') }}</a>
                                                        @endif

                                                        @if (permissionCheck('appointment.page.update'))
                                                            <a class="dropdown-item edit_row" data-bs-toggle="modal"
                                                               data-bs-target="#updatePage_{{ $row->id }}">{{ __('common.edit') }}</a>
                                                        @endif

                                                    </div>
                                                </div>

                                            </td>
                                        </tr>

                                        <div class="modal fade admin-query" id="updatePage_{{ $row->id }}">
                                            <div class="modal-dialog  modal-dialog-centered">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h4 class="modal-title">{{ __('common.Update') }}</h4>
                                                        <button type="button" class="close "
                                                                data-bs-dismiss="modal">
                                                            <i class="ti-close "></i>
                                                        </button>
                                                    </div>

                                                    <div class="modal-body">

                                                        <form action="{{ route('appointment.page.update', $row->id) }}" method="POST" enctype="multipart/form-data" class="form-horizontal">
                                                            @method('PUT')
                                                            @csrf


                                                        <div class="row">
                                                            <div class="col-xl-12">
                                                                <div class="primary_input mb-25">
                                                                    <label class="primary_input_label"
                                                                           for="">{{ __('common.Section') }} <strong
                                                                            class="text-danger">*</strong></label>
                                                                    <input class="primary_input_field" name="title"
                                                                           placeholder="-" id="addName" type="text"
                                                                           value="{{ $row->title }}">
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-12 text-center pt_15">
                                                            <div class="d-flex justify-content-center">
                                                                <button class="primary-btn semi_large2  fix-gr-bg"
                                                                        type="submit"><i class="ti-check"></i>
                                                                    {{ __('common.Save') }}
                                                                </button>
                                                            </div>
                                                        </div>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
@push('scripts')
@endpush
