<h4 class='border-bottom'>{{ __('appointment.Schedule') }}</h4>
<div id="meta">
    <i
        class="fa fa-question-circle"></i>{{ __('appointment.Choose the time for your first lesson. The timings are displayed in your local timezone') }}
    .
</div>
<div class="view_full_shedule_inner p-0">
    <div class="view_full_shedule_inner_calendar">
        <div class="view_full_shedule_inner_calendar_header">
            <div class="d-flex align-items-center" id="calendarChanges">
                <button id='icon' class="preWeekSchedule"
                    {{ date('Y-m-d', strtotime($weekDates[0])) < \Carbon\Carbon::now()->format('Y-m-d') ? 'disabled' : '' }}>
                    <i
                        class="fa fa-angle-left"></i></button>
                <button id='icon' class="nextWeekSchedule"><i class="fa fa-angle-right"></i></button>
                <span class='text-primary-2 fw-semibold' id="schedule_date">
                    {{ date('F j', strtotime($weekDates[0])) . ' - ' . date('F j', strtotime($weekDates[6])) . ' , ' . date('Y', strtotime($weekDates[0])) }}
                </span>
            </div>
            <div>
                <select class='active_nice_select' id="changeTimeZone">
                    @foreach ($timeZones as $zone)
                        <option value="{{ $zone->code }}"> {{ $zone->time_zone }}</option>
                    @endforeach

                </select>
            </div>
        </div>

        <div class="schedule_loader justify-content-center d-none" id="calender_pre_loader">
            <div class="row position-relative text-center">
                <div class="course-preloader ">
                    <i class="fa fa-spinner fa-spin fa-2x fa-fw"></i>
                </div>
            </div>
        </div>

        <div class="view_full_shedule_inner_calendar_body" id="calender_body">
            @php
                $tz = isset($userTimeZone) ? $userTimeZone : Settings('active_time_zone');
            @endphp
            @foreach ($periods as $date)
                <div id="calender_date">
                    @php
                        $teachingInfo = Modules\Appointment\Entities\Schedule::teachingInfo('no_slot', $date->format('Y-m-d'), $instructor->id, 'get');
                    @endphp
                    <div id="header" {{ count($teachingInfo) == 0 ? 'event-offday' : '' }}>
                        <span>{{ $date->format('l') }}</span>
                        <h4>{{ $date->format('d') }}</h4>
                    </div>

                    @foreach ($teachingInfo as $key => $scheduleInfo)
                        <div id="event_date">
                            <button class="scheduleBook" data-id="{{ $scheduleInfo->id }}">
                                {{ \Carbon\Carbon::parse($date->format('Y-m-d') . ' ' . $scheduleInfo->slotInfo->start_time)->setTimeZone($tz)->format('h:i A') }}
                                -
                                {{ \Carbon\Carbon::parse($date->format('Y-m-d') . ' ' . $scheduleInfo->slotInfo->end_time)->setTimeZone($tz)->format('h:i A') }}
                            </button>

                        </div>
                    @endforeach
                </div>
            @endforeach

        </div>

        <div class="view_full_shedule_inner_calendar_bottom d-none">
            <p>{{ __('appointment.The calendar is in your time zone') }} {{ $tz }}</p>
            <a href="#" class="theme_btn">{{ __('appointment.Confirm time') }}</a>
        </div>
    </div>
</div>
