<?php

namespace Modules\Appointment\Http\Requests;

use App\Traits\ValidationMessage;
use Illuminate\Foundation\Http\FormRequest;

class ScheduleRequest extends FormRequest
{
    use ValidationMessage;
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $rules = [
            'slot'=>['required', 'integer'],
            'user'=>['required', 'integer'],
            'category'=>['required', 'integer'],
            'sub_category'=>['sometimes', 'nullable'],
        ];
        if ($this->id) {
            $rules += [
                'start_date'=>['required', 'date']
            ];
        } else {
            $rules +=[
                'start_date'=>['required', 'date'],
                'end_date'=>['sometimes','nullable', 'date', 'after_or_equal:start_date'],
            ];
        }
        return $rules;
    }

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }
}
