<?php

namespace Modules\Appointment\Http\Controllers;

use App\User;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Brian2694\Toastr\Facades\Toastr;
use Modules\CourseSetting\Entities\Course;
use Modules\Appointment\Http\Requests\FlatCommissionRequest;

class CommissionController extends Controller
{

    public function flatCommissionStore(FlatCommissionRequest $request)
    {

        if (demoCheck()) {
            return redirect()->back();
        }

        try {
            UpdateGeneralSetting('appointment_commission', $request->appointment_commission);

            Toastr::success(trans('common.Operation successful'), trans('common.Success'));
            return redirect()->back();
        } catch (\Exception $e) {
            GettingError($e->getMessage(), url()->current(), request()->ip(), request()->userAgent());
        }
    }
}
