<?php $__env->startPush('styles'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('public/backend/css/student_list.css')); ?>"/>
<?php $__env->stopPush(); ?>


<?php $__env->startSection('mainContent'); ?>

    <?php echo generateBreadcrumb(); ?>


    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">
            <div class="row justify-content-center">

                <div class="col-lg-12 mt-40">
                    <div class="QA_section QA_section_heading_custom check_box_table">
                        <div class="QA_table ">
                            <!-- table-responsive -->
                            <div class="">
                                <table id="lms_table" class="table Crm_table_active3">
                                    <thead>
                                    <tr>
                                        <th scope="col"><?php echo e(__('common.SL')); ?></th>
                                        <th scope="col"><?php echo e(__('common.Date')); ?></th>
                                        <th scope="col"><?php echo e(__('frontend.OS')); ?></th>
                                        <th scope="col"><?php echo e(__('frontend.Browser')); ?></th>
                                        <th scope="col"><?php echo e(__('frontend.LogOut Date')); ?></th>
                                        <th scope="col"><?php echo e(__('common.Action')); ?></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php if(isset($logins)): ?>
                                        <?php $__currentLoopData = $logins; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=> $login): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td scope="row"><?php echo e(translatedNumber($key+1)); ?></td>
                                                <td><?php echo e(showDate($login->login_at)); ?></td>
                                                <td><?php echo e($login->os); ?></td>
                                                <td><?php echo e($login->browser); ?></td>
                                                <td><?php echo e($login->logout_at ? showDate($login->logout_at) : trans('common.N/A')); ?></td>
                                                <td>
                                                    <?php
                                                        $ip = request()->ip();
                                                        $browser = Browser::browserName();
                                                        $os = Browser::platformName();
                                                    ?>
                                                    <?php if(empty($login->logout_at)): ?>
                                                        <a href="#" data-bs-toggle="modal"
                                                           data-bs-target="#logOut" data-id="<?php echo e($login->id); ?>"
                                                           class="primary-btn radius_30px   fix-gr-bg text-white logoutBtn w-fit"><?php echo e(__('frontend.Logout from system')); ?></a>
                                                    <?php endif; ?>
                                                </td>

                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>


                <div class="modal fade admin-query" id="logOut">
                    <div class="modal-dialog modal-dialog-centered">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h4 class="modal-title">  <?php echo e(__('student.Student')); ?> <?php echo e(__('frontend.Logout from system')); ?> </h4>
                                <button type="button" class="btn-close" data-bs-dismiss="modal"><i
                                        class="ti-close "></i></button>
                            </div>

                            <div class="modal-body">
                                <form action="<?php echo e(route('log.out.device')); ?>" method="post">
                                    <?php echo csrf_field(); ?>

                                    <div class="text-center">

                                        <h4><?php echo e(__('common.Are you sure')); ?>? </h4>
                                        <p><?php echo e(__('common.Note')); ?>

                                            : <?php echo e(__('student.This feature allows students to login on other devices while crossing device limits')); ?></p>
                                    </div>
                                    <input type="hidden" name="id" value="" id="studentId">
                                    <div class="mt-40 d-flex justify-content-between">
                                        <button type="button" class="primary-btn tr-bg"
                                                data-bs-dismiss="modal"><?php echo e(__('common.Cancel')); ?></button>

                                        <button class="primary-btn fix-gr-bg"
                                                type="submit"><?php echo e(__('frontend.LogOut')); ?></button>

                                    </div>
                                </form>
                            </div>

                        </div>
                    </div>
                </div>
            </div>

        </div>
    </section>

<?php $__env->stopSection(); ?>
<?php $__env->startPush('scripts'); ?>
    <script>
        $(document).on('click', '.logoutBtn', function () {
            let id = $(this).data('id');
            $('#studentId').val(id);
        });

    </script>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('backend.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/minialms/app.minialms.com/Modules/StudentSetting/Providers/../Resources/views/activitylog.blade.php ENDPATH**/ ?>