<?php
    $merchantID =getPaymentEnv('PAYTM_MERCHANT_ID');
?>
<?php if(env('PAYTM_ENVIRONMENT')=='production'): ?>
    <script type="application/javascript" crossorigin="anonymous"
            src="https:\\securegw.paytm.in\merchantpgpui\checkoutjs\merchants\<?php echo $merchantID?>.js"></script>
<?php else: ?>
    <script type="application/javascript" crossorigin="anonymous"
            src="https:\\securegw-stage.paytm.in\merchantpgpui\checkoutjs\merchants\<?php echo $merchantID?>.js"></script>
<?php endif; ?>


<form action="#"
      method="post">
    <?php echo csrf_field(); ?>
    <input type="hidden" name="method"
           value="<?php echo e($gateway->method); ?>">
    <input type="hidden" name="test_amount"
           value="<?php echo e($amount); ?>">
    <button type="button" class="<?php echo e($type!='deposit' && $type!='booking'?'Payment_btn':''); ?>" onclick="openJsCheckout()">
        <img class="w-100"
             src="<?php echo e(asset($gateway->logo)); ?>"
             alt="">
    </button>

</form>

<script type="text/javascript">
    function openJsCheckout() {

        $('.preloader').fadeIn('slow');
        $.ajax({
            type: 'POST',
            url: '<?php echo e(route('paytm.make.payment')); ?>',
            data: {
                '_token': '<?php echo e(csrf_token()); ?>',
                'type': '<?php echo e($type??'test'); ?>',
                'amount': '<?php echo e($amount??1); ?>',
            },
            success: function (data) {
                $('.preloader').fadeOut('slow');
                $('.paytm-pg-loader').show();
                $('.paytm-overlay').show();
                if (data.txnToken == "") {
                    alert(data.message);
                    $('.paytm-pg-loader').hide();
                    $('.paytm-overlay').hide();
                    return false;
                }
                invokeBlinkCheckoutPopup(data.orderId, data.txnToken, data.amount)
            }, error: function (xhr, status, error) {
                $('.preloader').fadeOut('slow');
                toastr.error("<?php echo e(trans('payment.Phone number is required. Please update your profile')); ?>");
            }
        });

    }

    function invokeBlinkCheckoutPopup(orderId, txnToken, amount) {
        window.Paytm.CheckoutJS.init({
            "root": "",
            "flow": "DEFAULT",
            "data": {
                "orderId": orderId,
                "token": txnToken,
                "tokenType": "TXN_TOKEN",
                "amount": amount,
            },
            handler: {
                transactionStatus: function (data) {
                },
                notifyMerchant: function notifyMerchant(eventName, data) {
                    if (eventName == "APP_CLOSED") {
                        $('.paytm-pg-loader').hide();
                        $('.paytm-overlay').hide();
                        //location.reload();
                    }
                    console.log("notify merchant about the payment state");
                }
            }
        }).then(function () {
            window.Paytm.CheckoutJS.invoke();
        });
    }

</script>
<?php /**PATH /home/minialms/app.minialms.com/Modules/Paytm/Resources/views/paytm_btn.blade.php ENDPATH**/ ?>