<div>
    <div class="shop-slider owl-carousel">
        @for ($i = 0; $i < 10; $i++)
            <div class="shop-item bg-white">
                <div class="text-center position-relative">
                    <div class="shop-item-rating">
                        @for ($i = 0; $i < 4; $i++)
                            <i class="fa fa-star text-primary"></i>
                        @endfor
                        <i class="fa fa-star-half-alt text-primary"></i>
                    </div>
                    <a href="#" class="shop-item-img d-block">
                        <img src="{{themeAsset('img/others/shop/1.jpg')}}" alt="">
                    </a>
                </div>
                <div class="shop-item-content">
                    <span>Education</span>
                    <h4><a href="#" class="currentColor">Awesome Abacus For Kids Multiple Colors</a></h4>
                    <div class="d-flex align-items-end justify-content-between">
                        <div>
                            <del class="d-block fw-500">$743</del>
                            <strong class="fw-bold d-block">$160</strong>
                        </div>
                        <div>
                            <a href="#" class="theme-btn bg-secondary"><i class="far fa-shopping-cart"></i>Buy
                                Now</a>
                        </div>
                    </div>
                </div>
            </div>
        @endfor
    </div>
</div>
<script>
    (function() {
        'use strict'
        jQuery(document).ready(function() {
            const navLeft =
                '<svg width="23" height="19" viewBox="0 0 23 19" fill="none" xmlns="http://www.w3.org/2000/svg"> <path d="M8.3125 0.625244L0.499998 8.43778V10.6253L8.3125 18.4378L10.5313 16.2503L5.40625 11.094H22.8125V7.96903H5.40625L10.5625 2.81275L8.3125 0.625244Z" fill="currentColor"/></svg>';
            const navRight =
                '<svg width="23" height="18" viewBox="0 0 23 18" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M15.1875 17.8125L23 9.99996V7.81245L15.1875 -8.7738e-05L12.9687 2.18742L18.0937 7.3437H0.6875L0.6875 10.4687H18.0937L12.9375 15.625L15.1875 17.8125Z" fill="currentColor"/></svg>'

            // shop slider
            if ($(".shop-slider").children().length > 0) {

                $('.shop-slider').owlCarousel({
                    nav: true,
                    rtl: false,
                    navText: [navLeft, navRight],
                    dots: false,
                    items: 4,
                    lazyLoad: true,
                    autoplay: true,
                    autoplayHoverPause: true,
                    autoplayTimeout: $('#slider_transition_time').val() * 1000,
                    loop: true,
                    margin: 24,
                    responsive: {
                        0: {
                            items: 1
                        },
                        480: {
                            items: 1
                        },
                        768: {
                            items: 2
                        },
                        922: {
                            items: 3
                        },
                        1200: {
                            items: 4
                        }
                    }
                });
            }
        })
    })();
</script>
