<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Modules\FrontendManage\Entities\FrontPage;
use Modules\FrontendManage\Entities\HeaderMenu;

class AddUpcomingCoursesPageToFrontendPagesTable extends Migration
{

    public function up()
    {
        $data_preview = !function_exists('themeAsset') ? '' : themeAsset('img/snippets/preview/class/class_page_section.jpg');
        $url = validRouteUrl('upcoming_courses.index');
        $dynamic_href = routeIsExist('getDynamicData') ? route('getDynamicData') : '';
        $filter_category = trans('frontend.Filter Category');
        $class_category = trans('frontend.Class Category');
        $class_price = trans('frontend.Class Price');
        $level = trans('frontend.Level');
        $page = FrontPage::where('slug', '/upcoming-courses')->first();
        if (!$page) {
            $page = new FrontPage();
        }
        $page->name = 'Upcoming Courses';
        $page->title = 'Upcoming Courses';
        $page->sub_title = 'Upcoming Courses';
        $page->details = '
<div data-type="component-text"
     data-preview="' . $data_preview . '"
     data-aoraeditor-title="Upcoming Courses"
     data-aoraeditor-categories="Upcoming Courses Page"
>

    <input type="hidden" class="class_route" name="class_route" value="' . $url . '">
    <div class="courses_area">
        <div class="container">
            <div class="row">
                <div class="col-lg-4 col-xl-3">
                  <div class="course_category_chose  mt_10">
    <div class="course_title mb_30 d-flex align-items-center">
        <div class="d-flex align-items-center">
            <svg xmlns="http://www.w3.org/2000/svg" width="19.5" height="13" viewBox="0 0 19.5 13">
                <g id="filter-icon" transform="translate(28)">
                    <rect id="Rectangle_1" data-name="Rectangle 1" width="19.5" height="2" rx="1"
                          transform="translate(-28)" fill="var(--system_primery_color)"/>
                    <rect id="Rectangle data-name=" Rectangle 2
                    " width="15.5" height="2" rx="1"
                    transform="translate(-26 5.5)" fill="var(--system_primery_color)"/>
                    <rect id="Rectangle_3" data-name="Rectangle 3" width="5" height="2" rx="1"
                          transform="translate(-20.75 11)" fill="var(--system_primery_color)"/>
                </g>
            </svg>
            <h5 class="font_16 f_w_500 mb-0">' . $filter_category . '</h5>
        </div>
        <div class="popupClose"><i class="ti-close"></i></div>
    </div>

    <div class="course_category_inner">
        <div class="single_course_categry">
            <h4 class="font_18 f_w_700">
             ' . $class_category . '
            </h4>

            <div data-type="component-nonExisting"
                 data-preview=""
                 data-table=""
                 data-select="id,name"
                 data-order=""
                 data-limit=""
                 data-where-status="1"
                 data-view="_single_sidebar_category"
                 data-model="Modules\CourseSetting\Entities\Category"
                 data-with=""
            >
                <div class="dynamicData"
                     data-dynamic-href="' . $dynamic_href . '"></div>
            </div>

        </div>
        <div class="single_course_categry">
            <h4 class="font_18 f_w_700">

   ' . $level . '
            </h4>
            <div data-type="component-nonExisting"
                 data-preview=""
                 data-table=""
                 data-select="id,title"
                 data-order=""
                 data-limit=""
                 data-view="_single_sidebar_level"
                 data-model="Modules\CourseSetting\Entities\CourseLevel"
                 data-with=""
            >
                <div class="dynamicData"
                     data-dynamic-href="' . $dynamic_href . '"></div>
            </div>


        </div>
        <div class="single_course_categry">
            <h4 class="font_18 f_w_700">
               ' . $class_price . '
            </h4>
            <div data-type="component-nonExisting"
                 data-preview=""
                 data-table=""
                 data-select=""
                 data-order=""
                 data-limit=""
                 data-view="_single_sidebar_price"
                 data-model=""
                 data-with=""
            >
                <div class="dynamicData"
                     data-dynamic-href="' . $dynamic_href . '"></div>
            </div>
        </div>
        <div class="single_course_categry">
            <h4 class="font_18 f_w_700">
               Language
            </h4>
            <div data-type="component-nonExisting"
                 data-preview=""
                 data-table="languages"
                 data-select="id,name"
                 data-order=""
                 data-limit=""
                 data-where-status="1"
                 data-view="_single_sidebar_language"
                 data-model=""
                 data-with=""
            >
                <div class="dynamicData"
                     data-dynamic-href="' . $dynamic_href . '"></div>
            </div>
        </div>
    </div>

</div>
                </div>
                <div class="col-lg-8 col-xl-9">
                    <div data-type="component-nonExisting"
                         data-preview=""
                         data-table=""
                         data-select=""
                         data-order=""
                         data-limit=""
                         data-where-status="1"
                         data-where-is_upcoming_course="1"
                         data-where-publish_status="pending"
                         data-pagination="12"
                         data-view="_single_topic"
                         data-model="Modules\CourseSetting\Entities\Course"
                         data-with=""
                         data-request="type,language_id,level,category_id,order,search"
                    >
                        <div class="dynamicData"
                             data-dynamic-href="' . $dynamic_href . '"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>

</div>

        ';
        $page->slug = '/upcoming-courses';
        $page->status = 1;
        $page->is_static = 1;
        $page->save();

        $header_menu = HeaderMenu::where('link', 'upcoming-courses')->first();
        if ($page && $header_menu == null) {
            $menu = new HeaderMenu();
            $menu->type = "Dynamic Page";
            $menu->element_id = $page->id;
            $menu->title = $page->title;
            $menu->link = '/upcoming-courses';
            $menu->position = 10;
            $menu->save();

        }
    }


}
