<?php

namespace Modules\Tax\Http\Controllers;

use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Tax\Entities\TaxSetting;

class TaxSettingController extends Controller
{

    public function index()
    {
        $setting = TaxSetting::getData();
        return view('tax::setting', compact('setting'));
    }


    public function store(Request $request)
    {

        try {
            TaxSetting::updateOrCreate([
                'lms_id' => SaasInstitute()->id,
            ], [
                'status' => $request->status,
                'percentage' => $request->percentage,
                'tax_type' => $request->type
            ]);
            UpdateGeneralSetting('tax_status', $request->status);
            UpdateGeneralSetting('tax_percentage', $request->percentage);
            UpdateGeneralSetting('tax_type', $request->type);

            Toastr::success(trans('common.Operation successful'), trans('common.Success'));
            return redirect()->back();
        } catch (\Exception $e) {
            Toastr::error(trans('common.Operation failed'), trans('common.Failed'));
            return redirect()->back();
        }
    }

    public function status()
    {
        $setting = TaxSetting::getData();
        if ($setting->status == 1) {
            return true;
        } else {
            return false;
        }
    }

}
