<?php

namespace Modules\Tax\Entities;

use App\Country;
use App\Traits\Tenantable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Cache;

class CountryWishTax extends Model
{
    use Tenantable;

    protected $fillable = [];

    public function country()
    {
        return $this->belongsTo(Country::class, 'country_id')->withDefault();
    }

    public static function boot()
    {
        parent::boot();
        self::created(function ($model) {
            Cache::forget('countryWishTaxList_' . SaasDomain());
        });
        self::updated(function ($model) {
            Cache::forget('countryWishTaxList_' . SaasDomain());
        });
        self::deleted(function ($model) {
            Cache::forget('countryWishTaxList_' . SaasDomain());
        });
    }
}
