@extends('backend.master')
@php
    $table_name='coupons';
@endphp
@section('table')
    {{$table_name}}
@stop
@section('mainContent')

    {!! generateBreadcrumb() !!}


    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">

            <div class="row">

                <div class="col-lg-12 mb-30">
                    <div class="white_box mb_20">
                        <div class="white_box_tittle list_header">
                            <h4>{{__('quiz.filterBy')}} </h4>
                        </div>
                        <form action="" method="GET">
                            <div class="row">

                                <div class="col-lg-4 mt-20">

                                    <select class="primary_select" name="group" id="">
                                        <option data-display="{{__('quiz.selectGroup')}}"
                                                value=""> {{__('quiz.selectGroup')}}</option>
                                        @foreach($groups as $group)
                                            <option
                                                value="{{$group->id}}" {{$group->id==request('group')?'selected':''}}> {{$group->title}}</option>
                                        @endforeach
                                    </select>

                                </div>
                                <div class="col-lg-4 mt-20">
                                    <select class="primary_select "
                                            id="category" name="category">
                                        <option data-display=" {{__('common.Select')}} {{__('common.Category')}}"
                                                value="">{{__('common.Select')}} {{__('common.Category')}}
                                        </option>
                                        @foreach($categories as $category)
                                            @if($category->parent_id==0)
                                                @include('backend.categories._single_select_option',['category'=>$category,'level'=>1])
                                            @endif
                                        @endforeach
                                    </select>

                                </div>
                                <div class="col-lg-12 mt-3">
                                    <div class="search_course_btn ">
                                        <button type="submit"
                                                class="primary-btn radius_30px   fix-gr-bg">
                                            <i class="ti ti-search"></i>
                                            {{__('courses.Filter')}} </button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>

                <div class="col-lg-12 mt--1">
                    <div class="row">
                        <div class="col-lg-4  ">
                            <div class="main-title">
                                <h3 class="mb-30" id="page_title">{{__('quiz.Question List')}} </h3>
                            </div>
                        </div>
                    </div>
                    <form method="POST" action="{{ route('online_exam_question_assign') }}" class="form-horizontal"
                          enctype="multipart/form-data" id="student_form">
                        @csrf
                        <input type="hidden" id="survey_id" name="survey_id" value="{{ @$survey->id}}">
                        <div class="QA_section QA_section_heading_custom check_box_table">
                            <div class="QA_table ">

                                <table id="lms_table" class="table quiz_assign_table">
                                    <thead>
                                    <tr>
                                        <th>
                                            <label class="primary_checkbox d-flex ms-2 "
                                                   for="questionSelectAll">
                                                <input type="checkbox"
                                                       id="questionSelectAll"
                                                       value=""
                                                       @if(count($question_banks)==count($already_assigned)) checked
                                                       @endif
                                                       class="common-checkbox selectAllQuiz">
                                                <span class="checkmark"></span>
                                            </label>
                                        </th>
                                        <th> {{__('quiz.Group')}} </th>
                                        <th>{{__('survey.Survey Type')}}</th>
                                        <th>{{__('quiz.Question')}}</th>
                                        <th>{{__('quiz.Image')}}</th>
                                        {{--                                    <th>{{__('common.Action')}}</th>--}}
                                    </tr>
                                    </thead>
                                    <tbody>


                                    @foreach($question_banks as $question_bank)
                                        <tr class="abc">
                                            <td>
                                                <label class="primary_checkbox d-flex  "
                                                       for="question{{ @$question_bank->id}}">
                                                    <input type="checkbox" name="questions[]"
                                                           id="question{{ @$question_bank->id}}"
                                                           value="{{ @$question_bank->id}}"
                                                           {{in_array(@$question_bank->id, $already_assigned)? 'checked': ''}}
                                                           class="common-checkbox question">
                                                    <span class="checkmark"></span>
                                                </label>
                                            </td>
                                            <td>{{@$question_bank->group !=""?@$question_bank->group->title:""}}</td>
                                            <td>
                                                @php
                                                    if ($question_bank->type == "checkbox") {
                                                        echo trans('survey.Checkbox');
                                                    } elseif ($question_bank->type == "dropdown") {
                                                        echo trans('survey.Dropdown');
                                                    } elseif ($question_bank->type == "radio") {
                                                        echo trans('survey.Radio');
                                                    } elseif ($question_bank->type == "linear_scale") {
                                                        echo trans('survey.Linear Scale');
                                                    }   else {
                                                        echo trans('survey.TextArea');
                                                    }
                                                @endphp
                                            </td>
                                            <td>{!! $question_bank->question !!}</td>
                                            <td>
                                                @if (!empty($question_bank->image))
                                                    <img style="max-width: 150px;"
                                                         src="{{asset($question_bank->image)}}">
                                                @endif
                                            </td>

                                        </tr>

                                    @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </form>
                </div>

            </div>
        </div>
    </section>
    <input type="hidden" name="ques_assign" class="ques_assign"
           value="{{route('survey.survey_question_assign_by_ajax')}}">

@endsection
@push('scripts')

    <script>

        (function ($) {
            "use strict";
            dataTableOptions = updateColumnExportOption(dataTableOptions, [1, 2, 3]);

            let table = $(".quiz_assign_table").DataTable(dataTableOptions);

            $("body").on("click", ".question", function () {
                assignQuiz();
            });

            function assignQuiz() {

                let survey_id = $("#survey_id").val();
                let ques_assign = $(".ques_assign").val();
                let token = $(".csrf_token").val();
                let selectedQus = [];


                table
                    .rows()
                    .nodes()
                    .to$()
                    .find('input[type="checkbox"].question')
                    .each(function () {
                        if ($(this).is(":checked") == true) {
                            selectedQus.push($(this).val());
                        }
                    });

                console.log(selectedQus);

                if (!$(this).is(":checked")) {
                    $("#questionSelectAll").prop("checked", false);
                }
                $.ajax({
                    type: "POST",
                    url: ques_assign,
                    data: {
                        _token: token,
                        survey_id: survey_id,
                        questions: selectedQus,
                    },
                    success: function (data) {
                        toastr.success("{{trans('common.Operation successful')}}", "{{trans('common.Success')}}");
                    },
                    error: function (data) {
                        toastr.error("{{trans('common.Something Went Wrong')}}", "{{trans('common.Failed')}}");
                        location.reload();
                    },
                });
            }


            $("body").on("click", ".selectAllQuiz", function () {

                let survey_id = $("#survey_id").val();
                let ques_assign = $(".ques_assign").val();
                let token = $(".csrf_token").val();
                let selectedQus = [];

                if ($(".selectAllQuiz").is(":checked") == true) {
                    table
                        .rows()
                        .nodes()
                        .to$()
                        .find('input[type="checkbox"].question')
                        .each(function () {
                            $(this).prop("checked", true);
                        });
                } else {
                    table
                        .rows()
                        .nodes()
                        .to$()
                        .find('input[type="checkbox"].question')
                        .each(function () {
                            $(this).prop("checked", false);
                        });
                }

                table
                    .rows()
                    .nodes()
                    .to$()
                    .find('input[type="checkbox"].question')
                    .each(function () {
                        if ($(this).is(":checked") == true) {
                            selectedQus.push($(this).val());
                        }
                    });
                $.ajax({
                    type: "POST",
                    url: ques_assign,
                    data: {
                        _token: token,
                        survey_id: survey_id,
                        questions: selectedQus,
                    },
                    success: function (data) {
                        toastr.success("{{trans('common.Operation successful')}}", "{{trans('common.Success')}}");
                    },
                    error: function (data) {
                        toastr.error("{{trans('common.Something Went Wrong')}}", "{{trans('common.Failed')}}");
                        location.reload();
                    },
                });
            });
        })(jQuery);

    </script>
@endpush
