<?php

namespace Modules\Survey\Entities;

use App\Traits\Tenantable;
use Illuminate\Database\Eloquent\Model;
use Modules\Survey\Entities\SurveyQuestionSetAttribute;

class SurveyQuestionSet extends Model
{
    use Tenantable;

    protected $fillable = [];

    public function attributes()
    {
        return $this->hasMany(SurveyQuestionSetAttribute::class, 'set_id');
    }

    public function activeAttributes()
    {
        return $this->hasMany(SurveyQuestionSetAttribute::class, 'set_id')->where('status', 1);
    }
}
