@extends('backend.master')
@push('styles')
    <link rel="stylesheet" href="{{asset('public/modules/supportticket/css/style.css')}}"/>
    <style>
        .subject_link {
            color: #7C32FF !important;
            font-weight: 300 !important;
        }

        .limit_text {
            overflow: hidden;
            text-overflow: ellipsis;
            display: -webkit-box;
            -webkit-line-clamp: 2;
            -webkit-box-orient: vertical;

        }

        .no_reply_ticket {
            font-weight: 600 !important;
        }

        .color_inherit {
            color: #828bb2 !important;
        }

    </style>

@endpush
@section('mainContent')
    {{generateBreadcrumb()}}
    <section class="admin-visitor-area">
        <div class="container-fluid p-0">
            <form action="{{ route('ticket.tickets.index') }}" method="get">
                <div class="white-box">

                    <div class="d-flex justify-content-between">
                        <div class="bc-pages">
                            <h3 class="mb-20 mr-30 mb_xs_15px mb_sm_20px"
                                id="page_title">{{__('ticket.support_ticket')}}</h3>
                        </div>

                    </div>

                    <div class="row">

                        <div class="col-lg-4">
                            <div class="primary_input mb-25">
                                <label class="primary_input_label" for="">{{ __('common.Category') }} </label>
                                <select name="category_id" id="category_id" class="primary_select mb-15">
                                    <option value="" selected>{{__('common.Select')}}</option>
                                    @foreach ($CategoryList as $key => $item)
                                        <option {{isset($category_id)?$category_id == $item->id?'selected':'':''}}
                                                value="{{ $item->id }}">{{ $item->name }} </option>
                                    @endforeach

                                </select>
                                @if ($errors->has('category_id'))
                                    <span class="text-danger"
                                          id="error_category_id">{{ $errors->first('category_id') }}</span>
                                @endif
                            </div>
                        </div>

                        <div class="col-lg-4">
                            <div class="primary_input mb-25">
                                <label class="primary_input_label" for="">{{ __('ticket.priority') }}</label>
                                <select name="priority_id" id="priority_id" class="primary_select mb-15">
                                    <option value="" selected>{{__('common.Select')}}</option>
                                    @foreach ($PriorityList as $key => $item)
                                        <option {{isset($priority_id)?$priority_id == $item->id?'selected':'':''}}
                                                value="{{ $item->id }}">{{ $item->name }} </option>
                                    @endforeach

                                </select>
                                @if ($errors->has('priority_id'))
                                    <span class="text-danger"
                                          id="error_priority_id">{{ $errors->first('priority_id') }}</span>
                                @endif
                            </div>
                        </div>

                        <div class="col-lg-4">
                            <div class="primary_input mb-25">
                                <label class="primary_input_label" for="">{{ __('common.Status') }}</label>
                                <select name="status_id" id="status_id" class="primary_select mb-15">
                                    <option value="" selected>{{__('common.Select')}}</option>
                                    @foreach ($StatusList as $key => $status)
                                        <option {{isset($status_id)?$status_id == $status->id?'selected':'':''}}
                                                value="{{ $status->id }}">{{ $status->name }} </option>
                                    @endforeach

                                </select>
                                @if ($errors->has('status_id'))
                                    <span class="text-danger"
                                          id="error_status_id">{{ $errors->first('status_id') }}</span>
                                @endif
                            </div>
                        </div>

                        <div class="col-lg-12 small text-end">
                            <button type="submit" id="search_btn" class="primary-btn  small fix-gr-bg">
                                <span class="ti-search pe-2"></span>
                                {{__('common.Search')}}
                            </button>
                        </div>
                    </div>
                </div>
            </form>

            <div class="white-box mt-">
                <div class="row">
                    @if (permissionCheck('ticket.tickets.index'))
                        <div class="col-lg-12">
                            <div class="d-flex justify-content-between">
                                <h3 class="mb-20">{{__('ticket.ticket_list')}}</h3>
                                @if(permissionCheck('ticket.tickets.create'))
                                    <div class="bc-pages">
                                        <a href="{{ route('ticket.tickets.create') }}" id="add_new"
                                           class="primary-btn small  fix-gr-bg mb-3">
                                            <span class="ti-plus pe-2"></span>
                                            {{__('common.Add New')}}
                                        </a>
                                    </div>
                                @endif
                            </div>
                        </div>
                        <div class="col-lg-12">

                            <div class="row">
                                <div class="col-lg-12">

                                    <div class="QA_section QA_section_heading_custom check_box_table">
                                        <div class="QA_table ">

                                            <div class="">
                                                <div id="model_list">
                                                    <table id="dataListTable" class="table">
                                                        <thead>

                                                        <tr>

                                                            <th scope="col" width="5%">{{__('common.SL')}}</th>
                                                            <th scope="col" width="15%">{{__('common.User')}}</th>
                                                            <th scope="col" width="55%">{{__('ticket.ticket')}}</th>
                                                            <th scope="col"
                                                                width="15%">{{__('ticket.agent_assign')}}</th>
                                                            <th class="nowrap" scope="col"
                                                                width="10%">{{__('common.Action')}}</th>
                                                        </tr>
                                                        </thead>


                                                    </table>
                                                    <div class="modal fade admin-query" id="deleteItem">
                                                        <div class="modal-dialog modal-dialog-centered">
                                                            <div class="modal-content">
                                                                <div class="modal-header">
                                                                    <h4 class="modal-title">{{__('common.delete')}}
                                                                        {{__('ticket.ticket')}}</h4>
                                                                    <button type="button" class="btn-close"
                                                                            data-bs-dismiss="modal"><i
                                                                            class="ti-close "></i></button>
                                                                </div>
                                                                <div class="modal-body">
                                                                    <div class="text-center">
                                                                        <h4>{{__('common.Are you sure to delete ?')}}</h4>
                                                                    </div>
                                                                    <div class="mt-40 d-flex justify-content-between">

                                                                        <form id="deleteForm"
                                                                              action="{{route('ticket.tickets.destroy')}}"
                                                                              method="POST">
                                                                            @csrf
                                                                            <input type="hidden" id="dataId" name="id">
                                                                            <input type="submit"
                                                                                   class="primary-btn fix-gr-bg"
                                                                                   value="Delete"/>
                                                                        </form>

                                                                        <button type="button" class="primary-btn tr-bg"
                                                                                data-bs-dismiss="modal">{{__('common.Cancel')}}</button>
                                                                    </div>
                                                                </div>

                                                            </div>
                                                        </div>
                                                    </div>

                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                </div>
                            </div>
                        </div>
                    @endif
                    <input type="hidden" name="url" id="url2"
                           @if(strpos($_SERVER['REQUEST_URI'], '?' )==true) value="{{explode('?',$_SERVER['REQUEST_URI'])[1]}}"
                           @else value="0" @endif>
                </div>
            </div>
        </div>
    </section>

@endsection

@push('scripts')
    <script type="text/javascript">

        (function ($) {
            "use strict";

            $(document).on('change', '.assign_user_form', function () {
                $('#pre-loader').removeClass('d-none');
                this.form.submit();
            })

            var url = $('#url2').val();
            if (url == 0) {
                var new_url = "{{ route('ticket.get-data') }}";
            } else {
                var base_url = $('#url').val();
                var new_url = base_url + '/admin/ticket/search?' + url;
            }


            dataTableOptions.serverSide = true
            dataTableOptions.processing = true
            dataTableOptions.ajax = new_url;
            dataTableOptions.columns = [
                {data: 'DT_RowIndex', name: 'id'},
                {data: 'username', name: 'username'},
                {data: 'ticket', name: 'ticket'},
                {data: 'assign_aggent', name: 'assign_aggent'},
                {data: 'action', name: 'action'}
            ]
            dataTableOptions = updateColumnExportOption(dataTableOptions, [0, 1, 2]);


            $('#dataListTable').DataTable(dataTableOptions);

            $(document).on('click', '.delete_ticket', function (event) {
                event.preventDefault();
                let id = $(this).data('id');
                $('#deleteItem').modal('show');
                $('#dataId').val(id);
            });
        })(jQuery);

    </script>

@endpush
