<table class="table Crm_table_active3" id="lms_table">
    <thead>
    <tr>
        <th scope="col" width="5%">{{ __('common.ID') }}</th>
        <th scope="col" width="15%">{{ _trans('store.method_name') }}</th>
        <th scope="col" width="10%">{{ _trans('store.is_active') }}</th>
        <th scope="col" width="10%">{{ _trans('store.shipment_time') }}</th>
        <th scope="col" width="15%">{{ _trans('store.carrier') }}</th>
        <th scope="col" width="10%">{{ _trans('store.based_on') }}</th>
        <th scope="col" width="10%">{{ _trans('store.min_shopping') }}</th>
        <th scope="col" width="10%">{{ _trans('store.cost') }}</th>
        <th scope="col" width="15%">{{ __('common.Action') }}</th>
    </tr>
    </thead>
    <tbody>
    @foreach ($data['methods'] as $key => $method)
        <tr>
            <th>{{ translatedNumber($key + 1) }}</th>
            <td>{{ $method->method_name }}</td>
            <td>
                <x-backend.status :id="$method->id" :status="$method->is_active"
                                  :route="'shipping_methods.update_status'">
                </x-backend.status>

            </td>

            <td>{{ $method->shipment_time }}</td>
            <td>{{ $method->carrier->name }}</td>
            <td>{{ $method->cost_based_on }}</td>
            <td>{{ getPriceFormat($method->minimum_shopping) }}</td>
            <td>{{ getPriceFormat($method->cost) }}</td>
            <td>

                <div class="dropdown CRM_dropdown">
                    <button class="btn btn-secondary dropdown-toggle" type="button" id="dropdownMenu2"
                            data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        {{ __('common.select') }}
                    </button>
                    <div class="dropdown-menu dropdown-menu-right"
                         aria-labelledby="dropdownMenu1{{ @$method->id }}">

                        <a class="dropdown-item edit_brand"
                           href="{{ route('store.shiprate.edit', $method->id) }}">{{ __('common.Edit') }}</a>

                        <a onclick="confirm_modal('{{ route('store.shiprate.destroy', $method->id) }}');"
                           class="dropdown-item edit_brand">{{ __('common.Delete') }}</a>

                    </div>
                </div>

            </td>
        </tr>
    @endforeach
    </tbody>
</table>
@push('scripts')
    <script type="application/javascript">

        (function ($) {
            "use strict";
            dataTableOptions = updateColumnExportOption(dataTableOptions, [0, 1, 3, 4, 5, 6, 7,]);

            $('#lms_table').DataTable(dataTableOptions);

        })(jQuery);

    </script>
@endpush
