@extends('backend.master')
@section('styles')
    <style>
        .dashed {
            margin-top: 1rem;
            margin-bottom: 1rem;
            border: 0;
            border-top: 1px dashed var(--gradient_1);
        }
    </style>
@endsection

@section('mainContent')
    {{generateBreadcrumb()}}
    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">
            <div class="row">
                <div class="col-lg-12">
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="white-box">
                                <div class="add-visitor">
                                    <div class="main-title">
                                        <h3 class="mb-15">
                                            {{__('product.configuration')}}
                                        </h3>
                                    </div>

                                    <form method="POST" action="{{ route('store.shippingsetting.update') }}"
                                          class="form-horizontal" enctype="multipart/form-data">
                                        @csrf
                                        <div class="row">


                                            <div class="col-lg-12">
                                                <label class="primary_input_label"
                                                       for="">{{__('product.label_generate_use')}} <span
                                                        class="required_mark_theme">*</span></label>
                                                <ul class="permission_list sms_list">
                                                    <li>
                                                        <label class="primary_checkbox d-flex mr-12 ">
                                                            <input name="label_code" class="label_code" type="radio"
                                                                   id="label_code"
                                                                   value="barcode" {{@$row->label_code == 'barcode'? 'Checked' :''}}>
                                                            <span class="checkmark"></span>
                                                        </label>
                                                        <p>{{__('product.barcode')}}</p>
                                                    </li>
                                                    <li>
                                                        <label class="primary_checkbox d-flex mr-12 ">
                                                            <input name="label_code" class="label_code" type="radio"
                                                                   id="label_code"
                                                                   value="qrcode" {{@$row->label_code == 'qrcode'? 'Checked' :''}}>
                                                            <span class="checkmark"></span>
                                                        </label>
                                                        <p>{{__('product.qrcode')}}</p>
                                                    </li>
                                                    <li>
                                                        <label class="primary_checkbox d-flex mr-12 ">
                                                            <input name="label_code" class="label_code" type="radio"
                                                                   id="label_code"
                                                                   value="both" {{@$row->label_code == 'both'? 'Checked' :''}}>
                                                            <span class="checkmark"></span>
                                                        </label>
                                                        <p>{{__('product.both')}}</p>
                                                    </li>
                                                </ul>
                                                <span class="text-danger">{{$errors->first('label_code')}}</span>
                                            </div>


                                        </div>
                                        <div class="row">

                                            <div class="col-xl-12 mt-repeater no-extra-space">
                                                <label
                                                    class="mb-2">{{__('product.label_terms_and_conditions')}}</label>
                                                @if(count($conditions) > 0)
                                                    @foreach($conditions as $key =>$condition)
                                                        <div class="row">
                                                            <input type="hidden" name="conditionIds[{{$condition->id}}]"
                                                                   value="{{$condition->id}}">
                                                            <div class="col">
                                                                <div class="primary_input mb-25 position-relative">
                                                                    <input value="{{$condition->condition}}"
                                                                           name="eCondition[{{$condition->id}}]"
                                                                           id="condition"
                                                                           class="primary_input_field condition"
                                                                           placeholder="{{__('product.terms_and_conditions') }}"
                                                                           type="text">
                                                                </div>
                                                            </div>
                                                            <div class="col-lg-1 col-3">
                                                                <div class="position-relative form-group">
                                                                    <a data-condition="{{$condition->id}}"
                                                                       href="javascript:" data-repeater-delete
                                                                       class="primary-btn condition_delete small icon-only fix-gr-bg  mt-repeater-delete">
                                                                        <span class="fas fa-trash"></span>
                                                                    </a>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    @endforeach
                                                @endif
                                                <div data-repeater-list="conditions">
                                                    <div data-repeater-item class="mt-repeater-item">
                                                        <div class="mt-repeater-row">
                                                            <div class="row">
                                                                <div class="col">
                                                                    <div class="primary_input mb-25 position-relative">
                                                                        <input name="condition"
                                                                               class="primary_input_field condition"
                                                                               placeholder="{{__('product.terms_and_conditions') }}"
                                                                               type="text">
                                                                    </div>
                                                                </div>
                                                                <div class="col-lg-1 col-3">
                                                                    <div class="position-relative form-group">
                                                                        <a href="javascript:" data-repeater-delete
                                                                           class="primary-btn small icon-only fix-gr-bg  mt-repeater-delete">
                                                                            <span class="fas fa-trash"></span>
                                                                        </a>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-md-1"></div>
                                                <div class="col-md-offset-1 col-md-9">
                                                    <a href="javascript:" data-repeater-create
                                                       class="primary-btn radius_30px condition_edit  fix-gr-bg mt-repeater-add w-fit"><i
                                                            class="fa fa-plus"></i>{{__('product.add_more')}}</a>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-12  mt-4">
                                            <div class="d-flex justify-content-center  ">
                                                <button type="submit"
                                                        class="primary-btn semi_large csvFormBtn fix-gr-bg"
                                                        id="save_button_parent">
                                                    <i class="ti-check"></i>
                                                    {{__('common.Update')}}
                                                </button>
                                            </div>
                                        </div>
                                    </form>

                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
@push('scripts')
    <script src="{{asset('Modules/Store/Resources/assets/js/repeater/repeater.js')}}"></script>
    <script src="{{asset('Modules/Store/Resources/assets/js/repeater/indicator-repeater.js')}}"></script>
    <script>
        (function ($) {
            "use strict";
            $(document).ready(function () {

                $(document).on('click', '.condition_delete', function (event) {
                    event.preventDefault();
                    let id = $(this).data('condition');
                    let url = "{{route('store.label.terms_condition.destroy',':id')}}";
                    url = url.replace(':id', id);
                    let selectRow = $(this).parent().parent().parent();
                    $.ajax({
                        url: url,
                        type: "GET",
                        success: function (response) {
                            if (response.status == 200) {
                                selectRow.remove();
                                toastr.success("Condition Deleted Successfully");
                            }
                        },
                        error: function (response) {
                            toastr.error("Something went wrong");
                        }
                    });
                });
                fieldToggleBasedOnOrderConfirm();

                $(document).on('change', '.order_confirm_and_sync', function (event) {
                    fieldToggleBasedOnOrderConfirm();
                });

                function fieldToggleBasedOnOrderConfirm() {
                    let targetDiv = $('.auto_show_div');
                    let orderConfirm = $('.order_confirm_and_sync:checked').val();
                    if (orderConfirm === 'Automatic') {
                        targetDiv.show();
                    } else {
                        targetDiv.hide();
                    }
                }

            });
        })(jQuery);
    </script>
@endpush

