@extends('backend.master')


@php
    $table_name = 'product_attributes';
@endphp
@section('table')
    {{ $table_name }}
@endsection

@section('mainContent')

    @php
        $LanguageList = getLanguageList();
    @endphp

    {!! generateBreadcrumb() !!}

    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">
            <div class="row">
                <div class="col-lg-4">
                    <div class="white-box mb_30  student-details header-menu">

                        <div class="box_header common_table_header">
                            <div class="main-title d-md-flex mb-0">
                                <h3 class="mb-0">
                                    @if (!isset($edit))
                                        {{ __('product.Add New Attribute') }}
                                    @else
                                        {{ __('product.Update Attribute') }}
                                    @endif
                                </h3>
                                @if (isset($edit))
                                    @if (permissionCheck('store.attribute.index'))
                                        <a href="{{ route('store.attribute.index') }}"
                                           class="primary-btn small fix-gr-bg ms-4"
                                           style="line-height: 25px;" title="{{ __('courses.Add New') }}">+</a>
                                    @endif
                                @endif
                            </div>
                        </div>

                        <div class="row pt-0">
                            @if (isModuleActive('FrontendMultiLang'))
                                <ul class="nav nav-tabs no-bottom-border  mt-sm-md-20 mb-10 ms-3" role="tablist">
                                    @foreach ($LanguageList as $key => $language)
                                        <li class="nav-item">
                                            <a class="nav-link  @if (auth()->user()->language_code == $language->code) active @endif"
                                               href="#element{{ $language->code }}" role="tab"
                                               data-bs-toggle="tab">{{ $language->native }} </a>
                                        </li>
                                    @endforeach
                                </ul>
                            @endif
                        </div>

                        @if (isset($edit))
                            <form action="{{ route('store.attribute.update') }}" method="POST" id="category-form"
                                  name="category-form" enctype="multipart/form-data">
                                <input type="hidden" name="id" value="{{ $edit->id }}">
                                @else
                                    @if (permissionCheck('store.attribute.store'))
                                        <form action="{{ route('store.attribute.store') }}" method="POST"
                                              id="category-form"
                                              name="category-form" enctype="multipart/form-data">
                                            @endif
                                            @endif
                                            @csrf

                                            <div class="tab-content">
                                                @foreach ($LanguageList as $key => $language)
                                                    <div role="tabpanel"
                                                         class="tab-pane fade @if (auth()->user()->language_code == $language->code) show active @endif  "
                                                         id="element{{ $language->code }}">
                                                        <div class="row">
                                                            <div class="col-xl-12">
                                                                <div class="primary_input mb-25">
                                                                    <label class="primary_input_label"
                                                                           for="nameInput">{{ __('common.Name') }}
                                                                        <strong class="text-danger">*</strong></label>
                                                                    <input name="name[{{ $language->code }}]"
                                                                           id="nameInput"
                                                                           class="primary_input_field name {{ @$errors->has('name') ? ' is-invalid' : '' }}"
                                                                           placeholder="{{ __('common.Name') }}"
                                                                           type="text"
                                                                           value="{{ isset($edit) ? $edit->getTranslation('title', $language->code) : old('title.' . $language->code) }}">

                                                                    @if ($errors->has('name'))
                                                                        <span class="invalid-feedback d-block mb-10"
                                                                              role="alert">
                                                        <strong>{{ @$errors->first('name') }}</strong>
                                                    </span>
                                                                    @endif

                                                                </div>

                                                            </div>
                                                        </div>

                                                        <div class="row">
                                                            <div class="col-xl-12">
                                                                <div class="primary_input mb-15">
                                                                    <label class="primary_input_label" for="">
                                                                        {{ __('common.Description') }} </label>
                                                                    <textarea class="primary_textarea height_112"
                                                                              name="description[{{ $language->code }}]">{{ isset($edit) ? $edit->getTranslation('description', $language->code) : old('description.' . $language->code) }}</textarea>
                                                                </div>
                                                            </div>

                                                        </div>
                                                    </div>
                                                @endforeach

                                            </div>


                                            <div class="row">

                                                @if (isset($edit))
                                                    <div class="col-lg-12">
                                                        <span>{{ __('product.Attribute Value') }} </span> <span
                                                            class="text-danger">*</span>
                                                        <div
                                                            class="QA_section2 QA_section_heading_custom check_box_table">
                                                            <div class="QA_table mb_15">

                                                                <div class="table-responsive">
                                                                    <table class="table create_table">
                                                                        <tbody>
                                                                        @if (count($edit->values) > 0)
                                                                            @foreach ($edit->values as $key => $items)
                                                                                @if ($key == 0)
                                                                                    <tr class="variant_edit_row_lists">
                                                                                        <td class="ps-0 pb-0 border-0">
                                                                                            <input
                                                                                                class="primary_input_field"
                                                                                                value="{{ $items->value }}"
                                                                                                placeholder="-"
                                                                                                name="edit_variant_values[]"
                                                                                                type="text">
                                                                                            <input type="hidden"
                                                                                                   class="d-none"
                                                                                                   name="value_id[]"
                                                                                                   value="{{ $items->id }}">
                                                                                            <input type="hidden"
                                                                                                   class="d-none"
                                                                                                   name="value_with_id[]"
                                                                                                   value="{{ $items->value }}-{{ $items->id }}">
                                                                                        </td>

                                                                                        <td class="ps-0 pb-0 pe-0 border-0">
                                                                                            <div
                                                                                                class="add_items_button">
                                                                                                <button type="button"
                                                                                                        class="primary-btn primary-circle add_single_variant_edit_row fix-gr-bg w-fit">
                                                                                                    <i class="ti-plus"></i>
                                                                                                </button>
                                                                                            </div>
                                                                                        </td>
                                                                                    </tr>
                                                                                @else
                                                                                    <tr class="variant_edit_row_lists">
                                                                                        <td class="ps-0 pb-0 border-0">
                                                                                            <input
                                                                                                class="primary_input_field"
                                                                                                value="{{ $items->value }}"
                                                                                                placeholder="-"
                                                                                                name="edit_variant_values[]"
                                                                                                type="text">
                                                                                            <input type="hidden"
                                                                                                   class="d-none"
                                                                                                   name="value_id[]"
                                                                                                   value="{{ $items->id }}">
                                                                                            <input type="hidden"
                                                                                                   class="d-none"
                                                                                                   name="value_with_id[]"
                                                                                                   value="{{ $items->value }}-{{ $items->id }}">
                                                                                        </td>
                                                                                        <td class="ps-0 pb-0 pe-0 remove_edit border-0">

                                                                                            <div
                                                                                                class="items_min_icon ">
                                                                                                <i
                                                                                                    class="ti-trash"></i>
                                                                                            </div>

                                                                                        </td>

                                                                                    </tr>
                                                                                @endif
                                                                            @endforeach
                                                                        @else
                                                                            <tr class="variant_edit_row_lists">
                                                                                <td class="ps-0 pb-0 border-0">
                                                                                    <input class="primary_input_field"
                                                                                           name="edit_variant_values[]"
                                                                                           placeholder="-"
                                                                                           type="text">
                                                                                </td>
                                                                                <td class="ps-0 pb-0 pe-0 border-0">
                                                                                    <div class="add_items_button">
                                                                                        <button type="button"
                                                                                                class="primary-btn radius_30px add_single_variant_edit_row  fix-gr-bg">
                                                                                            <i
                                                                                                class="ti-plus"></i>
                                                                                        </button>
                                                                                    </div>
                                                                                </td>
                                                                            </tr>
                                                                        @endif

                                                                        </tbody>
                                                                    </table>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                @else
                                                    <div class="col-lg-12">
                                                        <span>{{ __('product.Attribute Value') }} </span> <span
                                                            class="text-danger">*</span>
                                                        <div
                                                            class="QA_section2 QA_section_heading_custom check_box_table">
                                                            <div class="QA_table mb_15">


                                                                <div class="table-responsive">
                                                                    <table class="table create_table">
                                                                        <tbody>
                                                                        <tr class="attribute_add variant_row_lists">
                                                                            <td class="ps-0 pb-0 border-0">
                                                                                <input class="primary_input_field"
                                                                                       id="variant_values"
                                                                                       name="variant_values[]"
                                                                                       placeholder="-"
                                                                                       type="text">
                                                                            </td>
                                                                            <td class="ps-0 pb-0 pe-0 border-0">
                                                                                <div class="add_items_button">
                                                                                    <button type="button"
                                                                                            class="primary-btn radius_30px add_single_variant_row  fix-gr-bg">
                                                                                        <i class="ti-plus"></i>
                                                                                    </button>
                                                                                </div>
                                                                            </td>
                                                                        </tr>
                                                                        <tr class="attribute_add variant_row_lists">
                                                                            <td class="ps-0 pb-0 border-0">
                                                                <span class="text-danger"
                                                                      id="error_variant_values"></span>
                                                                            </td>
                                                                        </tr>
                                                                        </tbody>
                                                                    </table>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>

                                                @endif

                                                @php
                                                    $tooltip = '';
                                                    if (permissionCheck('store.attribute.store')) {
                                                        $tooltip = '';
                                                    } else {
                                                        $tooltip = trans('courses.You have no permission to add');
                                                    }
                                                @endphp
                                                <div class="col-lg-12 text-center">
                                                    <div class="d-flex justify-content-center pt_20">
                                                        <button type="submit" class="primary-btn semi_large fix-gr-bg"
                                                                data-bs-toggle="tooltip"
                                                                title="{{ @$tooltip }}" id="save_button_parent">
                                                            <i class=" fa fa-check "></i>
                                                            @if (!isset($edit))
                                                                {{ __('common.Save') }}
                                                            @else
                                                                {{ __('common.Update') }}
                                                            @endif
                                                        </button>


                                                    </div>
                                                </div>
                                            </div>

                                        </form>
                    </div>

                </div>
                <div class="col-lg-8">
                    <div class="white-box">
                        <div class="box_header common_table_header">
                            <div class="main-title d-md-flex mb-0">
                                <h3 class="mb-0" id="page_title">{{ __('product.Attribute List') }}</h3>
                            </div>
                        </div>
                        <div class="  QA_section QA_section_heading_custom check_box_table">
                            <div class="QA_table ">
                                <div class="">
                                    <table id="lms_table" class="table table-data">
                                        <thead>
                                        <tr>
                                            <th scope="col">{{ __('common.SL') }}</th>
                                            <th scope="col">{{ __('common.Name') }}</th>
                                            <th scope="col">{{ __('common.Description') }}</th>
                                            <th scope="col">{{ __('common.Status') }}</th>
                                            <th scope="col">{{ __('common.Action') }}</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        @foreach ($attributes as $key => $category)
                                            <tr>
                                                <td>{{ ++$key }}</td>
                                                <td> {{ checkParent($category) }} {{ @$category->title }}</td>
                                                <td>{{ @$category->description }}</td>


                                                <td class="nowrap">
                                                    <x-backend.status :id="$category->id" :status="$category->status"
                                                                      :route="'store.attribute.status'">
                                                    </x-backend.status>

                                                </td>

                                                <td>
                                                    <!-- shortby  -->
                                                    <div class="dropdown CRM_dropdown">
                                                        <button class="btn btn-secondary dropdown-toggle" type="button"
                                                                id="dropdownMenu1{{ @$category->id }}"
                                                                data-bs-toggle="dropdown"
                                                                aria-haspopup="true" aria-expanded="false">
                                                            {{ __('common.Select') }}
                                                        </button>
                                                        <div class="dropdown-menu dropdown-menu-right"
                                                             aria-labelledby="dropdownMenu1{{ @$category->id }}">
                                                            @if (permissionCheck('store.attribute.view'))
                                                                <a class="dropdown-item view_attribute"
                                                                   data-id="{{$category->id}}">{{ __('common.View') }}</a>
                                                            @endif
                                                            @if (permissionCheck('store.attribute.edit'))
                                                                <a class="dropdown-item edit_brand"
                                                                   href="{{ route('store.attribute.edit', $category->id) }}">{{ __('common.Edit') }}</a>
                                                            @endif
                                                            @if (permissionCheck('store.attribute.destroy'))
                                                                <a onclick="confirm_modal('{{ route('store.attribute.destroy', $category->id) }}');"
                                                                   class="dropdown-item edit_brand">{{ __('common.Delete') }}</a>
                                                            @endif
                                                        </div>
                                                    </div>
                                                    <!-- shortby  -->
                                                </td>
                                            </tr>
                                            <!-- The Modal -->

                                            @include('store::partials.view_modal')
                                        @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>



    @include('store::partials.delete_modal')

@endsection

@include('store::attributes.scripts')

@push('scripts')
    <script>
        (function ($) {
            "use strict";
            $(document).on("click", ".view_attribute", function () {
                $('#view_modal' + $(this).data('id')).modal('show');
            });

            dataTableOptions = updateColumnExportOption(dataTableOptions, [0, 1, 2]);

            $('#lms_table').DataTable(dataTableOptions);

        })(jQuery);
    </script>
@endpush
