<?php

namespace Modules\Store\Repositories;

use App\Traits\ImageStore;
use Modules\Store\Entities\ShippingMethod;

class ShippingRepository
{
    use ImageStore;


    public function getAll()
    {
        try {
            $user_id = getParentSellerId();
            $methods = ShippingMethod::where('request_by_user', $user_id)
                ->whereHas('carrier', function ($q) {
                    $q->where('status', 1);
                })->with(['carrier'])->get();

            return $methods;
        } catch (\Throwable $th) {
        }
    }

    public function findById($id)
    {
        return ShippingMethod::find($id);
    }

    public function getRequestedSellerOwnShippingMethod()
    {
        $user_id = getParentSellerId();
        return ShippingMethod::where('request_by_user', $user_id)->where('is_approved', 0)->latest()->get();
    }

    public function getActiveAll()
    {
        $user_id = getParentSellerId();
        $methods = ShippingMethod::where('request_by_user', $user_id)->where('is_active', 1)->whereHas('carrier', function ($q) {
            $q->where('status', 1);
        })->with(['carrier'])->get();
        $methods = $methods->filter(function ($item) {

            return $item->id;
        });
        return $methods;
    }

    public function getActiveByCarrier($id)
    {
        $user_id = getParentSellerId();
        $methods = ShippingMethod::where('request_by_user', $user_id)->where('is_active', 1)->where('carrier_id', $id)->whereHas('carrier', function ($q) {
            $q->where('status', 1);
        })->with(['carrier'])->get();

        if (!isModuleActive('ShipRocket')) {
            $methods = $methods->filter(function ($item) {
                if ($item->carrier->slug != 'Shiprocket') {
                    return $item->id;
                }
            });
        }
        return $methods;
    }

    public function store($request)
    {
        try {
            $request = (object)$request;

            $shipping_method = new ShippingMethod();
            $shipping_method->method_name = $request->method_name;
            $shipping_method->carrier_id = $request->carrier_id;
            $shipping_method->cost_based_on = $request->cost_based_on;
            $shipping_method->cost = (float)$request->cost;
            $shipping_method->shipment_time = $request->shipment_time;
            $shipping_method->minimum_shopping =(float) $request->minimum_shopping;
            $shipping_method->request_by_user = getParentSellerId();
            $shipping_method->save();
            return true;
        } catch (\Throwable $th) {
            return false;
        }
    }

    public function find($id)
    {
        return ShippingMethod::findOrFail($id);
    }

    public function update($request)
    {
        try {
            $request = (object)$request;

            $user_id = getParentSellerId();

            $shipping_method = ShippingMethod::where('id', $request->id)->where('request_by_user', $user_id)->first();
            $shipping_method->method_name = $request->method_name;
            $shipping_method->carrier_id = $request->carrier_id;
            $shipping_method->cost_based_on = $request->cost_based_on;
            $shipping_method->cost = $request->cost;
            $shipping_method->shipment_time = $request->shipment_time;
            $shipping_method->minimum_shopping = $request->minimum_shopping;
            $shipping_method->request_by_user = getParentSellerId();
            $shipping_method->save();
            return true;
        } catch (\Throwable $th) {
            return false;
        }
    }

    public function delete($id)
    {
        $user_id = getParentSellerId();
        $shipping = ShippingMethod::where('id', $id)->where('request_by_user', $user_id)->first();
        $totals = ShippingMethod::where('request_by_user', $user_id)->pluck('id')->toArray();
        if ($shipping) {
            if (count($shipping->methodUse) > 0) {
                return 'not_possible';
            } elseif (count($totals) < 2) {
                return 'not_possible_for_1';
            } else {
                $shipping->delete();
                return 'possible';
            }
        } else {
            return 'invalid';
        }
    }

    public function updateStatus(array $data)
    {
        $user_id = getParentSellerId();
        $shipping_method = $this->find($data['id']);
        if ($data['status'] == 0) {
            $other_active_method = ShippingMethod::where('id', '!=', $data['id'])->where('request_by_user', $user_id)->where('is_active', 1)->pluck('id')->toArray();
            if (count($other_active_method) > 0) {
                $shipping_method->is_active = $data['status'];
                $shipping_method->save();
            } else {
                return 'last shipping rate disable not posible';
            }
        } else {
            $shipping_method->is_active = $data['status'];
            $shipping_method->save();
        }
        return 1;
    }

    public function updateApproveStatus($data)
    {
        $shipping_method = $this->find($data['id']);
        $shipping_method->is_approved = $data['status'];
        $shipping_method->save();
    }

    public function getActiveAllForAPI()
    {
        $methods = ShippingMethod::where('request_by_user', 1)->where('id', '>', 1)->where('is_active', 1)->whereHas('carrier', function ($q) {
            $q->where('status', 1);
        })->with(['carrier'])->get();
        if (!isModuleActive('ShipRocket')) {
            $methods = $methods->filter(function ($item) {
                if ($item->carrier->slug != 'Shiprocket') {
                    return $item->id;
                }
            });
        }
        return $methods;
    }
}
