<?php

namespace Modules\Store\Http\Controllers;

use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Store\Entities\ProductCategory;
use Modules\Store\Repositories\ProductCategoryRepository;

class CategoryController extends Controller
{
    use ValidatesRequests;

    public $ProductCategoryRepository;

    public function __construct(ProductCategoryRepository $ProductCategoryRepository)
    {
        $this->ProductCategoryRepository = $ProductCategoryRepository;
    }


    public function index()
    {
        try {

            $categories = ProductCategory::orderBy('position_order', 'asc')->get();
            $max_id = ProductCategory::max('position_order') + 1;

            return view('store::categories.index', compact('categories', 'max_id'));
        } catch (\Exception $e) {
            GettingError($e->getMessage(), url()->current(), request()->ip(), request()->userAgent());
        }
    }

    public function create()
    {
        return view('store::create');
    }

    public function store(Request $request)
    {

        $code = auth()->user()->language_code;

        $rules = [
            'name.' . $code => 'required|max:255',
        ];

        $this->validate($request, $rules, validationMessage($rules));


        $categrory = $this->ProductCategoryRepository->create($request);

        if ($categrory) {
            Toastr::success(trans('common.Operation successful'), trans('common.Success'));
            return redirect()->back();
        } else {
            Toastr::error(trans('common.Operation failed'), trans('common.Failed'));
            return redirect()->back();
        }
    }

    public function edit($id)
    {
        try {
            $edit = ProductCategory::find($id);
            $categories = ProductCategory::orderBy('position_order', 'asc')->get();
            $max_id = ProductCategory::max('position_order') + 1;

            return view('store::categories.index', compact('categories', 'edit', 'max_id'));
        } catch (\Exception $e) {
            GettingError($e->getMessage(), url()->current(), request()->ip(), request()->userAgent());
        }
    }

    public function update(Request $request)
    {

        $code = auth()->user()->language_code;

        $rules = [
            'name.' . $code => 'required|max:255',
        ];


        $this->validate($request, $rules, validationMessage($rules));

        $is_exist = ProductCategory::where('title', $request->name)->where('id', '!=', $request->id)->first();
        if ($is_exist) {
            Toastr::error(trans('frontend.This name has been already taken'), trans('common.Failed'));
            return redirect()->back();
        }

        try {
            $categrory = $this->ProductCategoryRepository->update($request);

            if ($categrory) {
                Toastr::success(trans('common.Operation successful'), trans('common.Success'));
                return redirect()->route('store.category.index');
            } else {
                Toastr::error(trans('common.Operation failed'), trans('common.Failed'));
                return redirect()->back();
            }
        } catch (\Exception $e) {
            GettingError($e->getMessage(), url()->current(), request()->ip(), request()->userAgent());
        }
    }


    public function destroy($id)
    {
        if (demoCheck()) {
            return redirect()->back();
        }
        try {

            $categrory = $this->ProductCategoryRepository->delete($id);
            if ($categrory) {
                Toastr::success(trans('common.Operation successful'), trans('common.Success'));
                return redirect()->back();
            } else {
                Toastr::error(trans('common.Operation failed'), trans('common.Failed'));
                return redirect()->back();
            }
        } catch (\Exception $e) {
            GettingError($e->getMessage(), url()->current(), request()->ip(), request()->userAgent());
        }
    }
}
