<?php

namespace Modules\Store\Entities;

use Illuminate\Database\Eloquent\Model;

class ProductShipping extends Model
{
    protected $fillable = [];
    protected $guarded = ['id'];

    public function shippingMethod()
    {
        return $this->belongsTo(ShippingMethod::class, 'shipping_method_id', 'id');
    }

    public function product()
    {
        return $this->belongsTo(Product::class, 'product_id', 'id');
    }
}
