<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Modules\RolePermission\Entities\Permission;

class AddTeacherPanelStorePermission extends Migration
{
    public function up()
    {
        $routes = [
            ['name' => 'My Panel', 'route' => 'users.my_panel.index', 'type' => 1, 'parent_route' => null],
            ['name' => 'Purchase History', 'route' => 'users.my_purchase.index', 'type' => 2, 'parent_route' => 'users.my_panel.index'],
            ['name' => 'Store Refund & Dispute', 'route' => 'users.store_refund_dispute.index', 'type' => 2, 'parent_route' => 'users.my_panel.index'],
        ];

        foreach ($routes as $key => $menu) {
            Permission::updateOrCreate([
                'route' => $menu['route'],
            ], [
                    'name' => $menu['name'],
                    'route' => $menu['route'],
                    'parent_route' => $menu['parent_route'],
                    'type' => $menu['type'],
                    'backend' => $menu['backend'] ?? 1,
                    'ecommerce' => 0,
                    'module' => null,
                    'section_id' => 1,
                    'position' => $key + 5000
                ]
            );
        }


    }

    public function down()
    {

    }
}
