<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddColumnsToCheckoutsTable extends Migration
{
    public function up()
    {
        Schema::table('checkouts', function (Blueprint $table) {
            if (!Schema::hasColumn('checkouts', 'order_number')) {
                $table->string('order_number')->nullable()->default(null)->unique();
            }
            if (!Schema::hasColumn('checkouts', 'is_paid')) {
                $table->unsignedInteger('is_paid')->default(0);
            }
            if (!Schema::hasColumn('checkouts', 'is_confirmed')) {
                $table->unsignedInteger('is_confirmed')->default(0);
            }
            if (!Schema::hasColumn('checkouts', 'is_completed')) {
                $table->unsignedInteger('is_completed')->default(0);
            }
            if (!Schema::hasColumn('checkouts', 'is_cancelled')) {
                $table->unsignedInteger('is_cancelled')->default(0);
            }
            if (!Schema::hasColumn('checkouts', 'cancel_reason_id')) {
                $table->unsignedInteger('cancel_reason_id')->nullable();
            }
            if (!Schema::hasColumn('checkouts', 'shipping_id')) {
                $table->unsignedInteger('shipping_id')->nullable();
            }
            if (!Schema::hasColumn('checkouts', 'is_store')) {
                $table->boolean('is_store')->default(0);
            }
            if (!Schema::hasColumn('checkouts', 'order_status')) {
                $table->integer('order_status')->default(1);
            }
            if (!Schema::hasColumn('checkouts', 'shipping_cost')) {
                $table->string('shipping_cost')->nullable();
            }
            if (!Schema::hasColumn('checkouts', 'is_received')) {
                $table->integer('is_received')->default(0);
            }

        });
    }


    public function down()
    {
    }
}
