<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateOrderProductDetailsTable extends Migration
{
    public function up()
    {
        Schema::create('order_product_details', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('package_id');
            $table->unsignedBigInteger('is_store');
            $table->unsignedBigInteger('seller_id');
            $table->unsignedBigInteger('course_id');
            $table->string('type', 50)->nullable();
            $table->unsignedInteger('qty')->default(0);
            $table->double('price')->default(0);
            $table->double('total_price')->default(0);
            $table->double('tax_amount')->default(0);
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('order_product_details');
    }
}
