<?php

namespace Modules\Noticeboard\Http\Controllers;

use Illuminate\Routing\Controller;
use Modules\Noticeboard\Http\Requests\NoticeboardRequest;
use Modules\Noticeboard\Repositories\Interfaces\NoticeboardRepositoryInterface;
use Modules\Noticeboard\Repositories\Interfaces\NoticeboardTypeRepositoryInterface;
use Modules\RolePermission\Repositories\RoleRepositoryInterface;

class NoticeboardController extends Controller
{
    protected $noticeboardRepository, $noticeboardTypeRepository, $roleRepository;

    public function __construct(
        NoticeboardRepositoryInterface     $noticeboardRepository,
        NoticeboardTypeRepositoryInterface $noticeboardTypeRepository,
        RoleRepositoryInterface            $roleRepository
    )
    {
        $this->noticeboardRepository = $noticeboardRepository;
        $this->noticeboardTypeRepository = $noticeboardTypeRepository;
        $this->roleRepository = $roleRepository;
    }

    public function index()
    {
        return view('noticeboard::notice.index', [
            'group' => 1,
            'notices' => $this->noticeboardRepository->allGeneral(['*'], ['user', 'noticeType', 'assign', 'assign.role']),
            'types' => $this->noticeboardTypeRepository->allActiveInArray('id', 'title'),
            'roles' => $this->roleRepository->allActiveInArray(),
        ]);
    }

    public function store(NoticeboardRequest $request)
    {
        if (demoCheck()) {
            return redirect()->back();
        }
        $this->noticeboardRepository->createNotice($request->validated());
        return redirect()->back();
    }

    public function update(NoticeboardRequest $request)
    {
        if (demoCheck()) {
            return redirect()->back();
        }
        $this->noticeboardRepository->updateNotice($request->validated());
        return redirect()->back();
    }

    public function delete(NoticeboardRequest $request)
    {
        if (demoCheck()) {
            return redirect()->back();
        }
        $this->noticeboardRepository->deleteNotice($request->validated());
        return redirect()->back();
    }


}
