@php use Carbon\Carbon; @endphp
@extends('backend.master')
@push('styles')
    <link rel="stylesheet" href="{{ asset('public/backend/css/class.css') }}"/>
@endpush
@php
    $table_name = 'courses';
@endphp
@section('table')
    {{ $table_name }}
@stop
@section('mainContent')

    {!! generateBreadcrumb() !!}
    <section class="admin-visitor-area up_st_admin_visitor">


        <div class="white_box mb_30  student-details header-menu">
            <div class="white_box_tittle list_header">
                <h4>
                    {{ $data['title']}}
                </h4>
            </div>
            <div class="col-lg-12">


                <input type="hidden" id="url" value="{{ url('/') }}">
                @php
                    $LanguageList = getLanguageList();
                    $target_item=$data['plan']->plan_specific_item->plan_specific_item_details();
                    $upfront_payment=$data['plan']->paymentSteps->where('payment_title','Upfront')->first();
                @endphp
                <form action="{{ route('installment.plan.update') }}" method="post" enctype="multipart/form-data">
                    @csrf
                    <div class="row pt-0">
                        @if (isModuleActive('FrontendMultiLang'))
                            <ul class="nav nav-tabs no-bottom-border  mt-sm-md-20 mb-10 ms-3" role="tablist">
                                @foreach ($LanguageList as $key => $language)
                                    <li class="nav-item">
                                        <a class="nav-link  @if (auth()->user()->language_code == $language->code) active @endif"
                                           href="#element{{ $language->code }}" role="tab"
                                           data-bs-toggle="tab">{{ $language->native }} </a>
                                    </li>
                                @endforeach
                            </ul>
                        @endif
                    </div>
                    <div class="tab-content">
                        @foreach ($LanguageList as $key => $language)
                            <div role="tabpanel"
                                 class="tab-pane fade @if (auth()->user()->language_code == $language->code) show active @endif  "
                                 id="element{{ $language->code }}">
                                <div class="row">

                                    <div class="col-xl-12">
                                        <div class="primary_input mb-25">
                                            <label class="primary_input_label d-flex"
                                                   for="">{{ _trans('installment.Plan') }}
                                                {{ __('common.Title') }} *
                                            </label>

                                            <input class="primary_input_field" name="title[{{ $language->code }}]"
                                                   placeholder="-" id="addTitle" type="text"
                                                   {{ $errors->has('title') ? 'autofocus' : '' }} value="{{$data['plan']->getTranslation('title', $language->code)}}">
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-xl-12">
                                        <div class="primary_input mb-35">
                                            <label class="primary_input_label d-flex"
                                                   for="">{{ _trans('installment.Plan') }}
                                                {{ _trans('installment.Description') }}
                                            </label>
                                            <textarea class="lms_summernote" name="description[{{ $language->code }}]"
                                                      id="addRequirements" cols="30"
                                                      rows="10">{!! $data['plan']->getTranslation('description', $language->code) !!}</textarea>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                    <div class="row">
                        <div class="col-xl-6">
                            <div class="primary_input mb-25">
                                <label class="primary_input_label" for="">
                                    {{ _trans('installment.Capacity') }}</label>
                                <input class="primary_input_field" name="capacity" placeholder="-" id="addCapacity"
                                       type="number"
                                       {{ $errors->has('capacity') ? 'autofocus' : '' }} value="{{$data['plan']->capacity}}">
                            </div>
                        </div>
                        <div class="col-xl-6">
                            <div class="primary_input mb-25">
                                <!--                                <label class="primary_input_label" for=""> {{ _trans('installment.Banner') }}
                                </label>
                                <div class="primary_file_uploader">
                                    <input class="primary-input filePlaceholder" type="text" id="placeholderFileOneName"
                                           placeholder="{{ $data['plan']->banner != null ?showPicName($data['plan']->banner) : __('frontendmanage.Browse Image') }}"
                                           readonly="">
                                    <button class="" type="button">
                                        <label class="primary-btn small fix-gr-bg"
                                               for="document_file_1_edit_banner">{{ __('common.Browse') }}</label>
                                        <input type="file" class="d-none fileUpload" name="banner"
                                               id="document_file_1_edit_banner">
                                    </button>
                                </div>-->
                                <x-upload-file
                                    name="banner"
                                    type="image"
                                    media_id="{{isset($data['plan'])?$data['plan']->banner_media?->media_id:''}}"
                                    label="{{ __('installment.Banner') }}"/>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-lg-6">
                            <h3>{{ _trans('installment.Features') }} </h3>
                        </div>
                        <div class="col-lg-4">
                            <a class="primary-btn radius_30px   fix-gr-bg" id="add_new_feature" href="#"><i
                                    class="ti-plus"></i>{{ _trans('installment.Add Feature') }} </a>
                        </div>
                    </div>
                    <div id="feature_list">
                        @if(isset($data['plan']))
                            @foreach ($data['plan']->features as $feature)
                                <div class="row">
                                    <div class="col-lg-6">
                                        <div class="primary_input mb-25">
                                            <input class="primary_input_field" name="features[]" placeholder="-"
                                                   id="addCapacity" type="text" value="{{$feature->title}}">
                                        </div>
                                    </div>
                                    <div class="col-lg-4 mt_10">
                                        <button type="button" class="primary-btn icon-only fix-gr-bg removePlanFeature">
                                            <span class="ti-trash pe-2"></span></button>
                                    </div>
                                </div>
                            @endforeach
                        @endif
                    </div>
                    <div class="row mb-20">
                        <div class="col-lg-3">
                            <div class="primary_input">
                                <label class="primary_input_label" for="">{{ __('coupons.Start Date') }}</label>
                                <div class="primary_datepicker_input">
                                    <div class="g-0  input-right-icon">
                                        <div class="col">
                                            <div class="">
                                                <input placeholder="{{ __('coupons.Start Date') }}"
                                                       class="primary_input_field primary-input date form-control  {{ @$errors->has('start_date') ? ' is-invalid' : '' }}"
                                                       id="start_date" type="text" name="start_date"
                                                       value="{{ isset($data['plan']) ? getJsDateFormat(Carbon::parse($data['plan']->start_datetime)->format(getActivePhpDateFormat())) : getJsDateFormat(date('m/d/Y')) }}"
                                                       autocomplete="off">

                                            </div>
                                        </div>
                                        <button class="" type="button">
                                            <i class="ti-calendar" id="start-date-icon"></i>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3">
                            <label class="primary_input_label mt-1">{{ _trans('installment.Start Time') }}
                                <span>*</span></label>
                            <div class="primary_input">
                                <input required
                                       class="primary-input primary_input_field  time form-control{{ @$errors->has('start_time') ? ' is-invalid' : '' }}"
                                       type="text" name="start_time"
                                       value="{{ isset($data['plan']) ? showTime($data['plan']->start_datetime) : old('start_time') }}">
                            </div>
                        </div>

                        <div class="col-lg-3">
                            <div class="primary_input">
                                <label class="primary_input_label"
                                       for="">{{ _trans('installment.End Date') }}</label>
                                <div class="primary_datepicker_input">
                                    <div class="g-0  input-right-icon">
                                        <div class="col">
                                            <div class="">
                                                <input placeholder="{{ _trans('installment.End Date') }}"
                                                       class="primary_input_field primary-input date form-control  {{ @$errors->has('end_date') ? ' is-invalid' : '' }}"
                                                       id="end_date" type="text" name="end_date"
                                                       value="{{ isset($data['plan']->end_datetime) ? getJsDateFormat(\Carbon\Carbon::parse($data['plan']->end_datetime)->format(getActivePhpDateFormat())) : '' }}"
                                                       autocomplete="off">

                                            </div>
                                        </div>
                                        <button class="" type="button">
                                            <i class="ti-calendar" id="start-date-icon"></i>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3">
                            <label class="primary_input_label mt-1">{{ _trans('installment.End Time') }} <span>*</span></label>
                            <div class="primary_input">
                                <input
                                    class="primary-input primary_input_field  time form-control{{ @$errors->has('end_time') ? ' is-invalid' : '' }}"
                                    type="text" name="end_time"
                                    value="{{ isset($data['plan']) ? showTime($data['plan']->end_datetime) : old('end_time') }}">
                            </div>
                        </div>
                    </div>
                    <h3>
                        {{ _trans('installment.Target Products') }}
                    </h3>
                    <div class="row">
                        <div class="col-lg-4">
                            <div class="primary_input mb-35">
                                <label class="primary_input_label" for="">{{ _trans('installment.Target Type') }}
                                </label>

                                <select class="primary_select" name="target_type" id="select_target_type">
                                    <option data-display="{{ _trans('installment.Target Type') }}" value="">
                                        {{ _trans('installment.Target Type') }} </option>
                                    <option
                                        value="all" {{$data['plan']->plan_specific_item->target_type=='all' ? 'selected' : ''}}>{{ _trans('installment.All Type') }} </option>
                                    <option
                                        value="course" {{$data['plan']->plan_specific_item->target_type=='course' ? 'selected' : ''}}>{{ _trans('installment.Course') }} </option>
                                    <option
                                        value="quiz" {{$data['plan']->plan_specific_item->target_type=='quiz' ? 'selected' : ''}}>{{ _trans('installment.Quiz') }} </option>
                                    <option
                                        value="live_class" {{$data['plan']->plan_specific_item->target_type=='live_class' ? 'selected' : ''}}>{{ _trans('installment.Live Class') }} </option>
                                </select>
                            </div>
                        </div>
                        <div class="col-lg-4" id="target_options" style="display: none">
                            <div class="primary_input mb-35">
                                <label class="primary_input_label"
                                       for="">{{ _trans('installment.Select Target') }} </label>

                                <select class="primary_select" name="target" id="target_item_options">
                                </select>
                            </div>
                        </div>
                        <div class="col-xl-4" id="specific_section" style="display:none">
                            <div class="primary_input mb-25">
                                <label class="primary_input_label" for="specific_item_select" id="specic_item_lebel">
                                </label>
                                <select name="specific_item[]" id="specific_item_select"
                                        class="multypol_check_select active mb-15 e1" multiple>

                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="row mt_20">
                        <div class="col-xl-6">
                            <div class="primary_input ">
                                <div class="row">
                                    <div class="col-md-4 ">
                                        <h3>{{ _trans('installment.Verification') }} </h3>
                                    </div>
                                    <label class="switch_toggle" for="checkbox_varification">
                                        <input type="checkbox" id="checkbox_varification"
                                               {{$data['plan']->verification_required==1? 'checked':''}} name="verification_required"
                                               value="1"
                                               onchange="planVerification(this)">
                                        <i class="slider round"></i>
                                    </label>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="varification_section">
                        <div class="row">
                            <div class="col-xl-12">
                                <div class="primary_input mb-35">
                                    <label class="primary_input_label d-flex"
                                           for="">{{ _trans('installment.Verification') }}
                                        {{ _trans('installment.Description') }}
                                    </label>
                                    <textarea class="lms_summernote" name="verification_description"
                                              id="addRequirements" cols="30"
                                              rows="10">{!! $data['plan']->verification_description !!}</textarea>
                                </div>
                                <small>
                                    {{ _trans('installment.This description will be shown to the user when they are going to purchase the plan.') }}
                                </small>
                            </div>

                        </div>
                        <div class="row">
                            <div class="col-lg-6">
                                <div class=" mb-25">

                                    <x-upload-file
                                        name="verification_banner"
                                        type="image"
                                        media_id="{{isset($data['plan'])?$data['plan']->verification_banner_media?->media_id:''}}"
                                        label="{{ __('installment.Verification Banner') }}"/>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="primary_input mb-25">

                                    <x-upload-file
                                        name="verification_video"
                                        type="video"
                                        media_id="{{isset($data['plan'])?$data['plan']->verification_video_media?->media_id:''}}"
                                        label="{{ __('installment.Verification Banner') }}"/>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-lg-6">
                            <div class="primary_input mb-25">
                                <label class="primary_input_label d-flex" for="upfront">
                                    {{ _trans('installment.Request Upload') }}</label>
                                <label class="switch_toggle" for="checkbox_request_upload">
                                    <input type="checkbox" id="checkbox_request_upload"
                                           {{$data['plan']->request_uploads == 1 ? 'checked' : ''}} name="request_uploads"
                                           value="1">
                                    <i class="slider round"></i>
                                </label>
                            </div>
                        </div>

                        <div class="col-lg-6">
                            <div class="primary_input mb-35">
                                <label class="primary_input_label"
                                       for="">{{ _trans('installment.Bypass verification for verified users') }}</label>

                                <label class="switch_toggle" for="checkbox_bypass_verification">
                                    <input type="checkbox" id="checkbox_bypass_verification"
                                           {{$data['plan']->bypass_verification_for_verified_users == 1 ? 'checked' : ''}} name="bypass_verification_for_verified_users"
                                           value="1">
                                    <i class="slider round"></i>
                                </label>
                            </div>
                        </div>
                    </div>
                    <h3>{{ _trans('installment.Payment') }} </h3>
                    <div class="row">
                        <div class="col-lg-6">
                            <div class="primary_input mb-25">
                                <label class="primary_input_label d-flex" for="upfront">
                                    {{ _trans('intallment.Upfront') }} *</label>
                                <input class="primary_input_field" name="upfront" placeholder="-" id="upfront"
                                       type="number"
                                       {{ $errors->has('upfront') ? 'autofocus' : '' }} value="{{$upfront_payment->payment_amount}}">
                            </div>
                        </div>

                        <div class="col-lg-6">
                            <div class="primary_input mb-35">
                                <label class="primary_input_label"
                                       for="">{{ _trans('installment.Upfront Type') }} </label>

                                <select class="primary_select" name="upfront_type">
                                    <option data-display="{{ _trans('installment.Upfront Type') }}" value="">
                                        {{ _trans('installment.Upfront Type') }} </option>
                                    <option
                                        value="fixed_amount" {{$upfront_payment->amount_type == 'fixed_amount' ?'selected' : ''}} >{{ _trans('installment.Fixed Amount') }} </option>
                                    <option
                                        value="percent" {{$upfront_payment->amount_type == 'percent' ?'selected' : ''}}>{{ _trans('installment.Percent') }} </option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-lg-9">
                            <h3>{{ _trans('installment.Payment Steps') }} </h3>
                        </div>
                        <div class="col-lg-2">
                            <a class="primary-btn radius_30px   fix-gr-bg" id="add_new_step" href="#"><i
                                    class="ti-plus"></i>{{ _trans('installment.Add Step') }} </a>
                        </div>
                    </div>
                    <div id="payment_step_list">
                        @if(isset($data['plan']))
                            @foreach ($data['plan']->paymentSteps->where('payment_title','!=','Upfront') as $key => $step)
                                <div class="row">
                                    <div class="col-lg-3">
                                        <div class="primary_input mb-25">
                                            <label class="primary_input_label d-flex"
                                                   for="payment_title"> {{ _trans('intallment.Title') }} *</label>
                                            <input class="primary_input_field"
                                                   name="payment_steps[{{$key}}][payment_title]" placeholder="-"
                                                   id="payment_title_{{$key}}" type="text"
                                                   value="{{$step->payment_title}}">
                                        </div>
                                    </div>
                                    <div class="col-lg-2">
                                        <div class="primary_input mb-25">
                                            <label class="primary_input_label d-flex"
                                                   for="payment_deadline"> {{ _trans('intallment.Deadline') }} *</label>
                                            <input class="primary_input_field"
                                                   name="payment_steps[{{$key}}][payment_deadline]" placeholder="-"
                                                   id="payment_deadline" type="number"
                                                   value="{{$step->payment_deadline}}">
                                        </div>
                                    </div>
                                    <div class="col-lg-2">
                                        <div class="primary_input mb-25">
                                            <label class="primary_input_label d-flex"
                                                   for="payment_amount"> {{ _trans('intallment.Amount') }} *</label>
                                            <input class="primary_input_field"
                                                   name="payment_steps[{{$key}}][payment_amount]" placeholder="-"
                                                   id="payment_amount" type="number" value="{{$step->payment_amount}}">
                                        </div>
                                    </div>
                                    <div class="col-lg-3">
                                        <div class="primary_input mb-35">
                                            <label class="primary_input_label"
                                                   for="">{{ _trans('installment.Amount Type') }} *</label>

                                            <select class="primary_select payment_step_payment_type"
                                                    name="payment_steps[{{$key}}][amount_type]">
                                                <option data-display="{{ _trans('installment.Amount Type') }}"
                                                        value="">{{ _trans('installment.Amount Type') }} </option>
                                                <option
                                                    value="fixed_amount" {{$step->amount_type=='fixed_amount' ? 'selected':''}}>{{ _trans('installment.Fixed Amount') }} </option>
                                                <option
                                                    value="percent" {{$step->amount_type=='percent' ? 'selected':''}}>{{ _trans('installment.Percent') }} </option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-lg-2" style="margin-top: 35px;">
                                        <button type="button" class="primary-btn icon-only fix-gr-bg removePaymentStep">
                                            <span class="ti-trash pe-2"></span></button>
                                    </div>
                                </div>
                            @endforeach
                        @endif
                    </div>
                    <div class="col-lg-12 text-center pt_15">
                        <div class="d-flex justify-content-center">
                            <button class="primary-btn semi_large2  fix-gr-bg" id="save_button_parent"
                                    type="submit"><i
                                    class="ti-check"></i> {{__('common.Update') }} {{_trans('installment.Plan') }}
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </section>
@endsection
@push('js')
    <script>
        (function ($) {
            "use strict";

            $('#add_new_feature').on('click', function (e) {
                e.preventDefault();
                var html = `<div class="row">
                        <div class="col-lg-6" >
                            <div class="primary_input mb-25">
                                <input class="primary_input_field" name="features[]" placeholder="-" id="addCapacity" type="text" value="">
                            </div>
                        </div>
                        <div class="col-lg-4 mt_10">
                            <button type="button" class="primary-btn icon-only fix-gr-bg removePlanFeature"><span class="ti-trash pe-2"></span></button>
                        </div>
                    </div>`;
                $('#feature_list').append(html);
            });
            $('#add_new_step').on('click', function (e) {
                e.preventDefault();
                var index = $('#payment_step_list').children().length + 1;
                var html = `<div class="row">
                            <div class="col-lg-3">
                                <div class="primary_input mb-25">
                                    <label class="primary_input_label d-flex" for="payment_title"> {{ _trans('intallment.Title') }} *</label>
                                    <input class="primary_input_field" name="payment_steps[${index}][payment_title]" placeholder="-" id="payment_title_${index}" type="text" value="">
                                </div>
                            </div>
                            <div class="col-lg-2">
                                <div class="primary_input mb-25">
                                    <label class="primary_input_label d-flex" for="payment_deadline"> {{ _trans('intallment.Deadline') }} *</label>
                                    <input class="primary_input_field" name="payment_steps[${index}][payment_deadline]" placeholder="-" id="payment_deadline" type="number" value="">
                                </div>
                            </div>
                            <div class="col-lg-2">
                                <div class="primary_input mb-25">
                                    <label class="primary_input_label d-flex" for="payment_amount"> {{ _trans('intallment.Amount') }} *</label>
                                    <input class="primary_input_field" name="payment_steps[${index}][payment_amount]" placeholder="-" id="payment_amount" type="number" value="">
                                </div>
                            </div>
                            <div class="col-lg-3">
                                <div class="primary_input mb-35">
                                    <label class="primary_input_label" for="">{{ _trans('installment.Amount Type') }} *</label>

                                    <select class="primary_select payment_step_payment_type" name="payment_steps[${index}][amount_type]">
                                        <option data-display="{{ _trans('installment.Amount Type') }}"
                                            value="">{{ _trans('installment.Amount Type') }} </option>
                                            <option value="fixed_amount">{{ _trans('installment.Fixed Amount') }} </option>
                                            <option value="percent">{{ _trans('installment.Percent') }} </option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-lg-2" style="margin-top: 35px;">
                                <button type="button" class="primary-btn icon-only fix-gr-bg removePaymentStep"><span class="ti-trash pe-2"></span></button>
                            </div>
                        </div>`;

                $('#payment_step_list').append(html);
                var notLastElement = $('#payment_step_list').children().not(':last');
                notLastElement.find('.payment_step_payment_type').niceSelect('update');

                $('#payment_step_list').children().last().find('.payment_step_payment_type').niceSelect();
            });

            $(document).on('click', '.removePlanFeature', function (e) {
                e.preventDefault();
                $(this).parent().parent().remove();
            });
            $(document).on('click', '.removePaymentStep', function (e) {
                e.preventDefault();
                $(this).parent().parent().remove();
            });

            function planVerification(el) {
                if ($(el).prop('checked') == true) {
                    $('.varification_section').fadeIn();
                } else {
                    $('.varification_section').fadeOut();
                }
            }

            function handleTargetType() {
                $('#target_item_options').html('');
                if ($(this).val() == 'course') {
                    $('#target_item_options').append(`
                        <option data-display="{{ _trans('installment.Select Target') }}" value="">{{ _trans('installment.Select Target') }} </option>
                        <option value="all_course" {{$data['plan']->plan_specific_item->target=='all_course' ? 'selected' : ''}}>{{ _trans('installment.All Course') }} </option>
                        <option value="specific_category" {{$data['plan']->plan_specific_item->target=='specific_category' ? 'selected' : ''}}>{{ _trans('installment.Specific Category') }} </option>
                        <option value="specific_instructor" {{$data['plan']->plan_specific_item->target=='specific_instructor' ? 'selected' : ''}}>{{ _trans('installment.Specific Instructor') }} </option>
                        <option value="specific_course" {{$data['plan']->plan_specific_item->target=='specific_course' ? 'selected' : ''}}>{{ _trans('installment.Specific Course') }} </option>
                    `);
                    $('#target_item_options').niceSelect('update');
                }

                if ($(this).val() == 'quiz') {
                    $('#target_item_options').append(`
                        <option data-display="{{ _trans('installment.Select Target') }}" value="">{{ _trans('installment.Select Target') }} </option>
                        <option value="all_quiz" {{$data['plan']->plan_specific_item->target=='all_quiz' ? 'selected' : ''}}>{{ _trans('installment.All Quiz') }} </option>
                        <option value="specific_instructor" {{$data['plan']->plan_specific_item->target=='specific_instructor' ? 'selected' : ''}}>{{ _trans('installment.Specific Instructor') }} </option>
                        <option value="specific_quiz" {{$data['plan']->plan_specific_item->target=='specific_quiz' ? 'selected' : ''}}>{{ _trans('installment.Specific Quiz') }} </option>
                    `);
                    $('#target_item_options').niceSelect('update');
                }

                if ($(this).val() == 'live_class') {
                    $('#target_item_options').append(`
                        <option data-display="{{ _trans('installment.Select Target') }}" value="">{{ _trans('installment.Select Target') }} </option>
                        <option value="all_live_class" {{$data['plan']->plan_specific_item->target=='all_live_class' ? 'selected' : ''}}>{{ _trans('installment.All Live Class') }} </option>
                        <option value="specific_instructor" {{$data['plan']->plan_specific_item->target=='specific_instructor' ? 'selected' : ''}}>{{ _trans('installment.Specific Instructor') }} </option>
                        <option value="specific_class" {{$data['plan']->plan_specific_item->target=='specific_class' ? 'selected' : ''}}>{{ _trans('installment.Specific Class') }} </option>
                    `);
                    $('#target_item_options').niceSelect('update');
                }

                if ($(this).val() == 'all') {
                    $('#target_options').fadeOut();
                } else {
                    $('#target_options').fadeIn();
                }
                $('#specific_section').fadeOut();
            }

            function handleTarget() {
                let selected_value = $(this).val();
                let specific_item_select = $('#specific_item_select');
                let specic_item_lebel = $('#specic_item_lebel');
                if (selected_value == 'specific_category') {
                    specific_item_select.html('');
                    @foreach ($data['categories'] as $category)
                    specific_item_select.append(`
                            <option value="{{ $category->id }}" {{in_array($category->id,$target_item) ? 'selected':''}}>{{ $category->name }}</option>
                        `);
                    @endforeach
                    specic_item_lebel.html(`{{ _trans('installment.Select Category') }}`);
                    $('#specific_section').fadeIn();
                    specific_item_select.attr('name', 'specific_category[]');
                }

                if (selected_value == 'specific_instructor') {
                    specific_item_select.html('');
                    @foreach ($data['instructors'] as $instructor)
                    specific_item_select.append(`
                            <option value="{{ $instructor->id }}" {{in_array($instructor->id,$target_item) ? 'selected':''}} >{{ $instructor->name }}</option>
                        `);
                    @endforeach
                    specic_item_lebel.html(`{{ _trans('installment.Select Instructor') }}`);
                    $('#specific_section').fadeIn();
                    specific_item_select.attr('name', 'specific_instructor[]');

                }
                if (selected_value == 'specific_course') {
                    specific_item_select.html('');
                    @foreach ($data['courses'] as $course)
                    specific_item_select.append(`
                            <option value="{{ $course->id }}" {{in_array($course->id,$target_item) ? 'selected':''}}>{{ $course->getTranslation('title', auth()->user()->language_code) }}</option>
                        `);
                    @endforeach
                    specic_item_lebel.html(`{{ _trans('installment.Select Course') }}`);
                    $('#specific_section').fadeIn();
                    specific_item_select.attr('name', 'specific_course[]');
                }
                if (selected_value == 'specific_quiz') {
                    specific_item_select.html('');
                    @foreach ($data['quizzes'] as $quiz)
                    specific_item_select.append(`
                            <option value="{{ $quiz->id }}" {{in_array($quiz->id,$target_item) ? 'selected':''}}>{{ $quiz->title }}</option>
                        `);
                    @endforeach
                    specic_item_lebel.html(`{{ _trans('installment.Select Quiz') }}`);
                    $('#specific_section').fadeIn();
                    specific_item_select.attr('name', 'specific_quiz[]');

                }
                if (selected_value == 'specific_class') {
                    specific_item_select.html('');
                    @foreach ($data['live_classes'] as $live_class)
                    specific_item_select.append(`
                            <option value="{{ $live_class->id }}" {{in_array($live_class->id,$target_item) ? 'selected':''}}>{{ $live_class->title }}</option>
                        `);
                    @endforeach
                    specic_item_lebel.html(`{{ _trans('installment.Select Live Class') }}`);
                    $('#specific_section').fadeIn();
                    specific_item_select.attr('name', 'specific_class[]');
                }
                if (selected_value == 'all_course' || selected_value == 'all_quiz' || selected_value == 'all_live_class') {
                    $('#specific_section').fadeOut();
                }
                $('select[multiple]').multiselect('reload');
            }

            $('#select_target_type').on('change', handleTargetType);
            $('#target_item_options').on('change', handleTarget);

            $(document).ready(function () {

                $('#select_target_type').trigger('change');
                $('#target_item_options').trigger('change');

                planVerification($('#checkbox_varification'));
            });

        })(jQuery);

    </script>
@endpush
