<?php

namespace Modules\Gift\Http\Controllers;

use App\User;
use Brian2694\Toastr\Facades\Toastr;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;
use Modules\CourseSetting\Entities\Course;
use Modules\Gift\Entities\GiftCart;
use Modules\Gift\Entities\GiftRecord;
use Modules\Gift\Http\Requests\GiftRequest;
use Modules\Payment\Entities\Cart;

class GiftController extends Controller
{
    public function giftForm(Request $request, $id, $slug)
    {
        $course = Course::where('id', $id)->first();
        $title = '';
        if ($course->type == 1) {
            $title = _trans('frontend.Gift this course');
        } elseif ($course->type == 2) {
            $title = _trans('frontend.Gift this quiz');
        } elseif ($course->type == 3) {
            $title = _trans('frontend.Gift this live class');
        }
        return view('gift::gift_form', compact('course', 'request', 'title'));
    }

    function checkGiftValidity($course)
    {
        $settings_validity = false;
        if (Settings('gift_is_enable') == 1) {
            $course_type = $course->type;
            if ($course_type == 1) {
                $settings_validity = Settings('gift_course') == 1 ? true : false;
            } elseif ($course_type == 2) {
                $settings_validity = Settings('gift_quiz') == 1 ? true : false;
            } elseif ($course_type == 3) {
                $settings_validity = Settings('gift_live_class') == 1 ? true : false;
            }

        } else {
            $settings_validity = false;
        }
        return $settings_validity;

    }

    public
    function giftStore(GiftRequest $request)
    {

        $request->validate([
            'name' => 'required',
            'email' => 'required|email',
            'date_time' => 'required',
            'message' => 'sometimes|max:500',
        ]);
        try {
            DB::beginTransaction();
            $course = Course::where('id', $request->course_id)->first();

            $find_user = User::where('email', $request->email)->first();

            $giftRecord = new GiftRecord();
            $giftRecord->user_id = auth()->user()->id;
            $giftRecord->course_id = $request->course_id;
            $giftRecord->gift_user_email = $request->email;
            $giftRecord->gift_receiver_id = isset($find_user) ? $find_user->id : null;
            $giftRecord->gift_send_time = Carbon::parse($request->date_time)->format('Y-m-d H:i:s');
            $giftRecord->gift_receiver_name = $request->name;
            $giftRecord->gift_message = $request->message;
            $giftRecord->gift_status = 1;

            if (!$this->checkGiftValidity($course)) {
                Toastr::error(_trans('gift.Gift Not Valid'), _trans('common.Failed'));
                return redirect()->back();
            }
            $giftRecord->save();

            $oldCart = Cart::where('user_id', auth()->user()->id)->when(isModuleActive('Appointment'), function ($query) {
                $query->whereNotNull('course_id');
            })->first();

            $cart = new Cart();
            $cart->user_id = auth()->user()->id;
            $cart->instructor_id = $course->user_id;
            $cart->course_id = $request->course_id;
            $cart->tracking = isset($oldCart) ? $oldCart->tracking : getTrx();
            if ($course->discount_price != null) {
                $cart->price = $course->discount_price;
            } else {
                $cart->price = $course->price;
            }
            $cart->is_gift = 1;
            $cart->gift_id = $giftRecord->id;
            $cart->save();


            $gift_cart = new GiftCart();
            $gift_cart->user_id = $cart->user_id;
            $gift_cart->instructor_id = $course->user_id;
            $gift_cart->course_id = $request->course_id;
            $gift_cart->tracking = $cart->tracking;
            if ($course->discount_price != null) {
                $gift_cart->price = $course->discount_price;
            } else {
                $gift_cart->price = $course->price;
            }
            $gift_cart->is_gift = 1;
            $gift_cart->gift_id = $giftRecord->id;
            $gift_cart->save();


            $giftRecord->price = $cart->price;
            $giftRecord->cart_id = $cart->id;
            $giftRecord->save();


            DB::commit();

            Toastr::success(_trans('frontend.Gift Added to your cart'), trans('common.Success'));

            return redirect()->route('CheckOut')->with('back', courseDetailsUrl(@$course->id, @$course->type, @$course->slug));

        } catch (\Throwable $e) {
            DB::rollBack();
            GettingError($e->getMessage(), url()->current(), request()->ip(), request()->userAgent());
        }

    }
}
