<?php

namespace Modules\Cashback\Entities;

use App\DepositRecord;
use Illuminate\Database\Eloquent\Model;
use Modules\CourseSetting\Entities\Course;
use Modules\Cashback\Entities\UserCashback;
use Modules\CourseSetting\Entities\CourseEnrolled;

class UserCashbackDetail extends Model
{
    protected $fillable = ['product_type'];

    public function user_cashback()
    {
        return $this->belongsTo(UserCashback::class, 'user_cashback_id', 'id');
    }

    public function product_info()
    {
        if (in_array($this->product_type, ['course', 'quiz', 'live_class'])) {
            return $this->belongsTo(Course::class, 'product_id', 'id');
        } elseif ($this->product_type == 'subscription') {
            return $this->belongsTo(CourseEnrolled::class, 'subscription_enrolled_id', 'id')->course();
        } elseif ($this->product_type == 'recharge') {
            return $this->belongsTo(DepositRecord::class, 'product_id', 'id');
        } else {
            return $this->belongsTo(Course::class, 'product_id', 'id');
        }
    }

    public function course_info()
    {
        return $this->belongsTo(Course::class, 'product_id', 'id');
    }

    public function subscription_info()
    {
        return $this->belongsTo(CourseEnrolled::class, 'subscription_enrolled_id', 'id');
    }
}
