<?php

namespace Modules\Cashback\Entities;

use App\User;
use Illuminate\Database\Eloquent\Model;
use Modules\Cashback\Entities\CashbackRule;
use Modules\Cashback\Entities\UserCashbackDetail;

class UserCashback extends Model
{
    protected $fillable = [];

    public function cashbackDetails(){
        return $this->hasMany(UserCashbackDetail::class,'user_cashback_id','id');
    }

    public function cashback_rule(){
        return $this->belongsTo(CashbackRule::class,'rule_id','id');
    }

    public function user(){
        return $this->belongsTo(User::class,'user_id','id');
    }
}
