<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Schema;

class AddBundleSubscriptionColumnHomeContent extends Migration
{

    public function up()
    {
        Schema::table('home_contents', function ($table) {

            if (Schema::hasColumn('home_contents', 'key')) {
                UpdateHomeContent('subscription_page_banner', 'public/frontend/infixlmstheme/img/banner/cta_bg.jpg');
                UpdateHomeContent('subscription_page_title', 'Limitless learning and more possibilities');
                UpdateHomeContent('subscription_page_sub_title', 'Choose from over 100,000 online video courses with new');
            } else {
                if (!Schema::hasColumn('home_contents', 'subscription_page_banner')) {
                    $table->string('subscription_page_banner')->default('public/frontend/infixlmstheme/img/banner/cta_bg.jpg');
                }

                if (!Schema::hasColumn('home_contents', 'subscription_page_title')) {
                    $table->string('subscription_page_title')->default('Limitless learning and more possibilities');
                }
                if (!Schema::hasColumn('home_contents', 'subscription_page_sub_title')) {
                    $table->string('subscription_page_sub_title')->default('Choose from over 100,000 online video courses with new');
                }
            }

        });
    }

    public function down()
    {
        //
    }
}
