<?php

Route::group(['prefix' => 'assignment', 'middleware' => ['auth', 'admin']], function () {
    Route::get('/list', 'AssignmentController@index')->name('assignment_list')->middleware('RoutePermissionCheck:assignment_list');
    Route::get('course-assignment', 'AssignmentController@courseAssignmentList')->name('courseAssignmentList')->middleware('RoutePermissionCheck:courseAssignmentList');
    Route::get('/add', 'AssignmentController@create')->name('assignment_add')->middleware('RoutePermissionCheck:assignment_add');
    Route::post('/add', 'AssignmentController@store')->name('assignment_store')->middleware('RoutePermissionCheck:assignment_add');
    Route::get('/edit/{id}', 'AssignmentController@show')->name('assignment_edit')->middleware('RoutePermissionCheck:assignment_edit');
    Route::post('/update', 'AssignmentController@update')->name('assignment_update')->middleware('RoutePermissionCheck:assignment_edit');
    Route::get('/delete/{id}', 'AssignmentController@destroy')->name('assignment_delete')->middleware('RoutePermissionCheck:assignment_delete');

    Route::get('/assign/{id}', 'AssignAssignmentController@assign')->name('assignment_assign')->middleware('RoutePermissionCheck:assignment_assign');
    Route::post('assign-save', 'AssignAssignmentController@assignStore')->name('assignment_assign_save')->middleware('RoutePermissionCheck:assignment_assign_save');

    Route::get('assignment-marking/{id}', 'AssignAssignmentMarkingController@assignmentMarking')->name('assignment_marking')->middleware('RoutePermissionCheck:assignment_marking');
    Route::post('assignment-marking', 'AssignAssignmentMarkingController@saveAssignmentMarks')->name('saveAssignmentMarks');
});

Route::group(['prefix' => 'assignment', 'middleware' => ['auth']], function () {
    Route::post('submit-assignment', 'AssignAssignmentMarkingController@submitAssignment')->name('submitAssignment')->middleware('RoutePermissionCheck:myAssignment');
});
