<?php

namespace Modules\Assignment\Entities;

use App\Traits\Tenantable;
use App\User;
use Illuminate\Database\Eloquent\Model;
use Modules\CourseSetting\Entities\Course;
use Modules\Setting\Entities\UsedMedia;

class InfixAssignment extends Model
{
    use Tenantable;

    protected $guarded = ['id'];

    public function course()
    {
        return $this->belongsTo(Course::class, 'course_id', 'id')->withDefault();
    }

    public function creator_info()
    {
        return $this->belongsTo(User::class, 'created_by', 'id')->withDefault();
    }

    public function attachment_media()
    {
        return $this->morphOne(UsedMedia::class, 'usable')->where('used_for', 'attachment');
    }


}
