<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateInfixAssignmentsTable extends Migration
{

    public function up()
    {
        Schema::create('infix_assignments', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->string('attachment')->nullable();
            $table->integer('course_id')->nullable();
            $table->longText('description');
            $table->double('marks')->nullable();
            $table->double('min_parcentage')->nullable();
            $table->date('last_date_submission')->nullable();
            $table->integer('status')->deault(1)->nullable();
            $table->integer('created_by')->deault(1)->nullable();
            $table->integer('assignment_from')->deault(1)->nullable()->comment('1= Quiz, 2= Course');
            $table->integer('lms_id')->default(1);

            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('infix_assignments');
    }
}
